/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import info.istlab.IoTP.SerialWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FolderSelector<E>
extends JDialog
implements ActionListener {
    ArrayList<E> options;
    Hashtable<String, E> hash;
    String messageIfZero;
    boolean okClicked = false;
    E selectedItem;

    public FolderSelector(ArrayList<E> opts, String message, String _messageIfZero) {
        super(new JFrame(), message, true);
        this.options = opts;
        this.messageIfZero = _messageIfZero;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        if (opts.size() == 0) {
            this.setTitle(_messageIfZero);
        }
        this.hash = new Hashtable();
        for (E obj : this.options) {
            String label = obj.toString();
            JButton b = new JButton(label);
            b.addActionListener(this);
            this.add(b);
            this.hash.put(label, obj);
        }
        JButton cancelB = new JButton("cancel");
        cancelB.addActionListener(e -> {
            this.okClicked = false;
            System.out.println("Cancel is clicked.");
            this.dispose();
        });
        this.add(cancelB);
        this.pack();
        this.setLocation(SerialWindow.centerOfScreen(this.getSize()));
    }

    public boolean showDialog() {
        this.okClicked = false;
        if (this.options.size() == 1) {
            this.okClicked = true;
            this.selectedItem = this.options.get(0);
        } else {
            this.setVisible(true);
        }
        return this.okClicked;
    }

    public E getSelectedItem() {
        if (this.showDialog()) {
            if (this.options.size() == 0) {
                JOptionPane.showMessageDialog(null, this.messageIfZero);
                return null;
            }
            if (this.options.size() == 1) {
                return this.options.get(0);
            }
            return this.selectedItem;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selectedItem = this.hash.get(e.getActionCommand());
        this.okClicked = true;
        this.dispose();
    }
}

