/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import info.istlab.IoTP.App;
import info.istlab.IoTP.JTAConsole;
import info.istlab.IoTP.SerialWindow;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class ScriptRunner
implements Runnable {
    String scriptfile;
    String scriptfile_base;
    String srcfile;
    Thread thread;
    Process process;
    String originalButtonLabel;
    ArrayList<String> comlist;

    public ScriptRunner(String shfile, String targetfile) {
        this.scriptfile_base = shfile;
        this.scriptfile = App.isWindows ? this.scriptfile_base + ".bat" : this.scriptfile_base + ".sh";
        this.srcfile = targetfile;
        this.prepareComList();
    }

    public void startstop() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            this.process.destroyForcibly();
            this.thread = null;
        }
    }

    public void prepareComList() {
        this.comlist = new ArrayList();
        if (App.isWindows) {
            SerialWindow.check(false);
            this.comlist.add("cmd");
            this.comlist.add("/c");
            this.comlist.add("start");
            this.comlist.add(this.scriptfile);
            if (this.srcfile != null && this.srcfile.length() > 0) {
                this.comlist.add(this.srcfile);
            }
            if (App.serialName != null) {
                this.comlist.add(App.serialName);
            }
        } else {
            this.comlist.add("bash");
            this.comlist.add(this.scriptfile);
            if (this.srcfile != null && this.srcfile.length() > 0) {
                this.comlist.add(this.srcfile);
            }
            if (App.serialName != null) {
                this.comlist.add(App.serialName);
            }
        }
        for (String key : SerialWindow.hash.keySet()) {
            SerialWindow swin;
            if (!key.equals(App.serialName) || (swin = SerialWindow.hash.get(key)) == null) continue;
            swin.closeSerialPort(null);
        }
        while (!JTAConsole.winStack.isEmpty()) {
            JTAConsole jcon = JTAConsole.winStack.pop();
            jcon.closeWin();
        }
    }

    @Override
    public void run() {
        ProcessBuilder processBuilder = new ProcessBuilder(this.comlist);
        processBuilder.directory(new File(App.workingDir));
        JTAConsole con = new JTAConsole("(Exec) " + this.scriptfile + " " + this.srcfile);
        con.Systemoutprintln("=== \u5b9f\u884c\u958b\u59cb ===");
        if (App.isWindows) {
            con.Systemoutprintln("=== \u30d0\u30c3\u30c1\u30d5\u30a1\u30a4\u30eb\u3092\u5b9f\u884c\u3057\u307e\u3059 ===");
            con.Systemoutprintln(String.join((CharSequence)" ", this.comlist.toArray(new String[0])));
        }
        try {
            this.process = processBuilder.start();
            con.startBR(this.process);
            this.process.waitFor();
        }
        catch (IOException | InterruptedException e1) {
            e1.printStackTrace();
        }
        con.Systemoutprintln("=== \u7d42\u4e86 === (ALT+W\u3067\u9589\u3058\u308b)");
        this.thread = null;
        if (this.scriptfile_base.startsWith("Upload")) {
            SerialWindow.disposeByName(App.serialName);
            SerialWindow.invoke(false);
        }
        if (App.isWindows) {
            con.windowClosing(null);
            con.frame.dispose();
        }
    }
}

