/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import java.sql.Timestamp;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

class MqttSubscriber
implements MqttCallback {
    Timestamp recieveTime;
    Timestamp lastTime;
    String broker = "";
    String topic = "";
    MqttCallback callback;
    MqttClient client;

    public MqttSubscriber(String brokerHostName, String port, String subscribeTopic, MqttCallback _callback) {
        this.broker = "tcp://" + brokerHostName + ":" + port;
        this.topic = subscribeTopic;
        this.callback = _callback;
    }

    @Override
    public void connectionLost(Throwable cause) {
        System.out.println("Connection lost");
        System.exit(1);
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws MqttException {
        System.out.print("Topic : " + topic + "  ");
        System.out.println("Message: " + new String(message.getPayload()));
    }

    public boolean isNew() {
        boolean flag = false;
        flag = this.recieveTime != this.lastTime;
        this.lastTime = this.recieveTime;
        return flag;
    }

    public static void main(String[] args) throws InterruptedException {
        try {
            MqttSubscriber subscriber = new MqttSubscriber("10.104.91.19", "1883", "+", null);
            subscriber.subscribe();
        }
        catch (MqttException me) {
            System.out.println("reason: " + me.getReasonCode());
            System.out.println("message: " + me.getMessage());
            System.out.println("localize: " + me.getLocalizedMessage());
            System.out.println("cause: " + me.getCause());
            System.out.println("exception: " + me);
        }
    }

    public void subscribe() throws MqttException, InterruptedException {
        int qos = 2;
        String clientId = "Subscribe";
        if (this.client != null) {
            this.client.disconnect();
            this.client.close();
        }
        this.client = new MqttClient(this.broker, "Subscribe", new MemoryPersistence());
        if (this.callback == null) {
            this.client.setCallback(this);
        } else {
            this.client.setCallback(this.callback);
        }
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(false);
        this.client.setTimeToWait(10000L);
        System.out.println("Connecting to broker:" + this.broker);
        this.client.connect(connOpts);
        System.out.println("Subscribe topic :" + this.topic);
        this.client.subscribe(this.topic, 2);
    }

    public void unsubscribe() throws MqttException, InterruptedException {
        if (this.client != null) {
            this.client.disconnect();
            this.client.close();
        }
        System.out.println("Disconnected");
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken arg0) {
    }
}

