/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

class MqttPublisher {
    String broker = "";
    String topic = "";

    public MqttPublisher(String brokerHostName, String publishTopic) {
        this.broker = "tcp://" + brokerHostName + ":1883";
        this.topic = publishTopic;
    }

    public void publish(String publishMessage) {
        int qos = 2;
        String clientId = "Publisher";
        try {
            MqttClient mqttClient = new MqttClient(this.broker, "Publisher", new MemoryPersistence());
            MqttConnectOptions connOpts = new MqttConnectOptions();
            connOpts.setCleanSession(false);
            mqttClient.connect(connOpts);
            MqttMessage message = new MqttMessage(publishMessage.getBytes());
            message.setQos(2);
            mqttClient.publish(this.topic, message);
            mqttClient.disconnect();
            mqttClient.close();
        }
        catch (MqttException me) {
            System.out.println("reason: " + me.getReasonCode());
            System.out.println("message: " + me.getMessage());
            System.out.println("localize: " + me.getLocalizedMessage());
            System.out.println("cause: " + me.getCause());
            System.out.println("exception: " + me);
        }
    }
}

