/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import com.fazecast.jSerialComm.SerialPort;
import info.istlab.IoTP.App;
import info.istlab.IoTP.Launcher;
import info.istlab.IoTP.SerialWindow;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;

public class SerialChecker
implements Runnable {
    Launcher launcher;
    Thread thread;
    String last_connections;
    ArrayList<String> validSerialNames;
    Hashtable<String, String> invalidSerialNames;
    Hashtable<String, SerialPort> portHash;

    public SerialChecker(Launcher _launcher) {
        this.launcher = _launcher;
        this.last_connections = "";
        this.validSerialNames = new ArrayList();
        this.invalidSerialNames = new Hashtable();
        this.getBoardListForInvalid();
        this.portHash = new Hashtable();
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void getBoardListForInvalid() {
        ProcessBuilder processBuilder = new ProcessBuilder("arduino-cli", "board", "list");
        if (App.isWindows) {
            System.out.println(App.userhome + File.separator + "bin" + File.separator + "arduino-cli");
            processBuilder = new ProcessBuilder(App.userhome + File.separator + "bin" + File.separator + "arduino-cli", "board", "list");
        }
        ArrayList<String> out = new ArrayList<String>();
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("(USB)") != -1) continue;
                out.add(line);
            }
            process.waitFor();
        }
        catch (IOException | InterruptedException e1) {
            e1.printStackTrace();
        }
        for (String s : out) {
            String[] a = s.split(" ");
            if (a[0].indexOf("\u30b7\u30ea\u30a2\u30eb") != -1) continue;
            this.invalidSerialNames.put(a[0], a[0]);
        }
    }

    @Override
    public void run() {
        while (this.thread != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.check_update();
        }
    }

    void check_update() {
        String currentString = this.getCurrentSerialNames();
        if (!this.last_connections.equals(currentString)) {
            System.out.println("Serial state changed");
            System.out.println(currentString);
            this.updateSerialNames();
            this.launcher.updateTitle(currentString);
            this.launcher.updateSerialMenu(this.validSerialNames);
            if (this.last_connections.length() > currentString.length()) {
                String[] sep = this.last_connections.split(" ");
                Hashtable<String, String> currentHash = new Hashtable<String, String>();
                for (String t : this.validSerialNames) {
                    currentHash.put(t, t);
                }
                for (String s : sep) {
                    SerialWindow deadWin;
                    if (currentHash.get(s) != null || (deadWin = SerialWindow.hash.get(s)) == null) continue;
                    deadWin.disposeWin();
                }
            } else {
                String key = currentString;
                if (SerialWindow.hash.get(key) != null) {
                    SerialWindow.hash.get(key).reconnect();
                }
            }
        }
        this.last_connections = currentString;
    }

    String getCurrentSerialNames() {
        SerialPort[] ports = SerialPort.getCommPorts();
        StringBuffer sb = new StringBuffer();
        for (SerialPort sp : ports) {
            String name = sp.getSystemPortName();
            if (!name.startsWith("cu.usbserial") && !name.startsWith("COM") || this.invalidSerialNames.containsKey(name)) continue;
            sb.append(name + " ");
        }
        return sb.toString().trim();
    }

    void updateSerialNames() {
        SerialPort[] ports;
        this.validSerialNames.clear();
        this.portHash.clear();
        for (SerialPort sp : ports = SerialPort.getCommPorts()) {
            String name = sp.getSystemPortName();
            if (!name.startsWith("cu.usbserial") && !name.startsWith("COM") || this.invalidSerialNames.containsKey(name)) continue;
            this.validSerialNames.add(name);
            this.portHash.put(name, sp);
        }
    }
}

