/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import info.istlab.IoTP.FolderSelector;
import info.istlab.IoTP.Launcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;

public class App {
    static String userhome;
    static ArrayList<File> iotDirs;
    static String workingDir;
    public static String latestVersion;
    public static Path execPath;
    public static String downloadurl;
    public static boolean isWindows;
    public static String serialName;

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
            }
        });
        try {
            execPath = App.getApplicationPath(new App().getClass());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        iotDirs = new ArrayList();
        App.findDotGitFileRecursive(new File(userhome), iotDirs, 0);
        FolderSelector<File> fs = new FolderSelector<File>(iotDirs, "\u30d5\u30a9\u30eb\u30c0\u304c\u8907\u6570\u307f\u3064\u304b\u308a\u307e\u3057\u305f\u3002\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "\u30d5\u30a9\u30eb\u30c0\u304c1\u3064\u3082\u307f\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
        File ret = fs.getSelectedItem();
        if (ret == null) {
            System.exit(0);
        }
        workingDir = ret.getAbsolutePath();
        System.out.println(ret);
        new Launcher(ret).setVisible(true);
    }

    public static void findDotGitFileRecursive(File dir, ArrayList<File> iotDirs, int level) {
        if (level > 3) {
            return;
        }
        File[] list = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
        if (list == null) {
            return;
        }
        for (File tempdir : list) {
            if (tempdir.getName().equals("SampleSrc")) {
                iotDirs.add(tempdir);
                continue;
            }
            App.findDotGitFileRecursive(tempdir, iotDirs, level + 1);
        }
    }

    public static Path getApplicationPath(Class<?> cls) throws URISyntaxException {
        ProtectionDomain pd = cls.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL location = cs.getLocation();
        URI uri = location.toURI();
        Path path = Paths.get(uri);
        return path;
    }

    public static boolean isLatest() {
        StringBuilder sb = new StringBuilder();
        latestVersion = null;
        try {
            URL url = new URL(downloadurl);
            InputStream is = url.openConnection().getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (latestVersion == null) {
                    latestVersion = line.trim();
                    System.out.println(line);
                }
                sb.append(line + "\n");
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[" + latestVersion + "]");
        if (execPath.getFileName().toString().equals("classes")) {
            return true;
        }
        return latestVersion.equals(execPath.getFileName().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String download() {
        try {
            URL url = new URL(downloadurl + "/" + latestVersion);
            ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(latestVersion);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            fileChannel.close();
            fileOutputStream.close();
            File execjar = new File(execPath.getParent().toString() + File.separator + latestVersion);
            execjar.setExecutable(true);
            String string = execjar.getAbsolutePath();
            return string;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    public static void reboot(String pathfile) {
        ProcessBuilder processBuilder;
        String com;
        if (isWindows) {
            pathfile = pathfile.replaceAll("\\\\", "\\\\\\\\");
            com = "java -jar " + new File(pathfile).getName();
            processBuilder = new ProcessBuilder("cmd", "/c", com);
        } else {
            com = "sleep 1 ; java -jar " + pathfile;
            processBuilder = new ProcessBuilder("bash", "-c", com);
        }
        System.out.println(com);
        try {
            processBuilder.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread t = new Thread(Launcher.theapp);
        t.start();
    }

    static {
        downloadurl = "https://cit.istlab.info/IoTP/target/";
        userhome = System.getProperty("user.home");
        String os = System.getProperty("os.name").toLowerCase();
        isWindows = os.contains("windows");
    }
}

