/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import info.istlab.IoTP.App;
import info.istlab.IoTP.IndentProgram;
import info.istlab.IoTP.Launcher;
import info.istlab.IoTP.ScriptRunner;
import info.istlab.IoTP.SearchTFKeyListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class Editor
extends JFrame
implements ActionListener,
KeyListener {
    static Editor lastOpened;
    File file;
    RSyntaxTextArea textArea;
    JPanel topP;
    JSlider fontSizeJS;
    JButton saveB;
    JButton runB;
    JButton compileB;
    JButton execB;
    JButton fixIndentB;
    JTextField searchTF;
    ScriptRunner runner;

    public Editor(File f) {
        this.file = f;
        this.textArea = new RSyntaxTextArea(20, 40);
        this.textArea.setFont(new FontUIResource("sansserif", 0, 16));
        this.getContentPane().add(new RTextScrollPane(this.textArea));
        this.textArea.addKeyListener(this);
        this.textArea.setAutoIndentEnabled(true);
        this.textArea.setTabSize(2);
        this.textArea.setTabsEmulated(true);
        try {
            String d = new String(App.workingDir + File.separator);
            if (d.contains("\\")) {
                d = d.replace("\\", "\\\\");
            }
            this.setTitle(this.file.getCanonicalPath().replaceAll(d, ""));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.setSize(new Dimension(800, 400));
        if (Launcher.theapp != null) {
            Point launchP = Launcher.theapp.getLocationOnScreen();
            this.setLocation(launchP.x + Launcher.theapp.getWidth(), launchP.y);
        }
        this.setDefaultCloseOperation(1);
        this.load();
        this.topP = new JPanel();
        this.topP.setLayout(new FlowLayout(1, 1, 2));
        this.topP.add(new JLabel("size:"));
        this.fontSizeJS = new JSlider(10, 50, 16);
        this.topP.add(this.fontSizeJS);
        this.fontSizeJS.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int size = Editor.this.fontSizeJS.getValue();
                Editor.this.textArea.setFont(new FontUIResource("sansserif", 0, size));
            }
        });
        this.saveB = new JButton("Save");
        this.saveB.addActionListener(this);
        this.saveB.setEnabled(false);
        this.saveB.setToolTipText("\u4fdd\u5b58 (CTRL+S)");
        if (this.file.getName().endsWith(".ino")) {
            this.textArea.setSyntaxEditingStyle("text/c");
            this.textArea.setCodeFoldingEnabled(true);
            this.topP.add(this.saveB);
        } else if (this.file.getName().endsWith(".sh")) {
            this.textArea.setSyntaxEditingStyle("text/unix");
            this.topP.add(this.saveB);
        } else if (this.file.getName().endsWith(".class")) {
            this.textArea.setEditable(false);
        } else {
            this.topP.add(this.saveB);
        }
        JButton loadB = new JButton("Reload");
        loadB.addActionListener(this);
        this.topP.add(loadB);
        loadB.setToolTipText("\u518d\u8aad\u307f\u8fbc\u307f");
        if (this.textArea.getSyntaxEditingStyle() == "text/unix") {
            this.runB = new JButton("Run");
            this.runB.addActionListener(this);
            this.topP.add(this.runB);
            this.runner = new ScriptRunner(this.file.getAbsolutePath(), null);
        } else if (this.textArea.getSyntaxEditingStyle() == "text/c") {
            this.execB = new JButton("Upload");
            this.execB.setToolTipText("\u30b3\u30f3\u30d1\u30a4\u30eb\u3068\u66f8\u304d\u8fbc\u307f (CTRL+U)");
            this.execB.addActionListener(this);
            this.topP.add(this.execB);
        }
        this.fixIndentB = new JButton("\u30a4\u30f3\u30c7\u30f3\u30c8\u8abf\u6574");
        this.fixIndentB.setToolTipText("\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u306e\u81ea\u52d5\u30d5\u30a9\u30fc\u30de\u30c3\u30c8 (CTRL+I or CTRL+T)");
        this.topP.add(this.fixIndentB);
        this.fixIndentB.addActionListener(e -> this.fixIndent());
        this.searchTF = new JTextField("search (CTRL+F)", 11);
        this.searchTF.setToolTipText("\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u306e\u691c\u7d22(CTRL+F) \u5165\u529b\u3057\u3066Enter Esc\u3067\u7d42\u4e86");
        this.searchTF.setForeground(Color.GRAY);
        this.searchTF.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (Editor.this.searchTF.getText().equals("search (CTRL+F)")) {
                    Editor.this.searchTF.setText("");
                    Editor.this.searchTF.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (Editor.this.searchTF.getText().isEmpty()) {
                    Editor.this.searchTF.setForeground(Color.GRAY);
                    Editor.this.searchTF.setText("search (CTRL+F)");
                }
            }
        });
        SearchTFKeyListener searchAgent = new SearchTFKeyListener(this.textArea, this.searchTF);
        this.searchTF.addActionListener(searchAgent);
        this.searchTF.addKeyListener(searchAgent);
        this.topP.add(this.searchTF);
        this.getContentPane().add((Component)this.topP, "North");
        this.setVisible(true);
        this.textArea.requestFocus();
        this.textArea.setCaretPosition(0);
        lastOpened = this;
    }

    private void fixIndent() {
        int lineNo = this.textArea.getCaretPosition();
        String src = this.textArea.getText();
        String out = "";
        try {
            out = IndentProgram.indent(src);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.textArea.setText(out);
        this.textArea.setCaretPosition(lineNo);
        this.saveB.setEnabled(!src.equals(out));
    }

    public static String loadFile(File f) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return sb.toString();
    }

    public void load() {
        this.textArea.setText(Editor.loadFile(this.file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        String src = this.textArea.getText();
        try (PrintWriter out = null;){
            out = new PrintWriter(this.file.getAbsolutePath(), "UTF-8");
            out.println(src);
            out.flush();
        }
        System.out.println("\u4fdd\u5b58\u3057\u307e\u3057\u305f");
        this.saveB.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Save")) {
            this.save();
        } else if (e.getActionCommand().equals("Reload")) {
            this.load();
        } else if (e.getActionCommand().equals("Run")) {
            this.runner.startstop();
        } else if (e.getActionCommand().equals("Upload")) {
            this.save();
            new ScriptRunner("Upload", this.file.getName()).startstop();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.saveB.setEnabled(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) {
            if (e.getKeyCode() == 83) {
                this.save();
            }
            if (e.getKeyCode() == 85) {
                this.save();
                new ScriptRunner("Upload", this.file.getName()).startstop();
            }
            if (e.getKeyCode() == 87) {
                this.setVisible(false);
            }
            if (e.getKeyCode() == 73 || e.getKeyCode() == 84) {
                this.fixIndent();
            }
            if (e.getKeyCode() == 70) {
                this.searchTF.requestFocus();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

