/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import info.istlab.IoTP.App;
import info.istlab.IoTP.CommandRunner;
import info.istlab.IoTP.Editor;
import info.istlab.IoTP.FileTreeModel;
import info.istlab.IoTP.GitManager;
import info.istlab.IoTP.JTAConsole;
import info.istlab.IoTP.MqttWindow;
import info.istlab.IoTP.MyTreeCellRenderer;
import info.istlab.IoTP.ScriptRunner;
import info.istlab.IoTP.SerialChecker;
import info.istlab.IoTP.SerialWindow;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.MouseInputListener;
import javax.swing.tree.TreePath;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;

public class Launcher
extends JFrame
implements MouseInputListener,
KeyListener,
Runnable {
    public static Launcher theapp;
    public static String version;
    static int reboot_msec;
    File root;
    GitManager gitrepom;
    JTree tree;
    Hashtable<File, Editor> file2editor;
    SerialChecker serialChecker;
    JMenu serialMenu;
    public static ArrayList<Process> allProcs;

    public Launcher(File _root) {
        super("IoTP v" + version);
        this.setDefaultCloseOperation(3);
        this.file2editor = new Hashtable();
        theapp = this;
        this.root = _root;
        try {
            this.gitrepom = new GitManager(this.root);
            this.gitrepom.checkClean();
        }
        catch (IOException | GitAPIException | NoWorkTreeException e) {
            e.printStackTrace();
        }
        FileTreeModel model = new FileTreeModel(this.root, false);
        this.tree = new JTree();
        this.tree.setModel(model);
        this.tree.addMouseListener(this);
        this.tree.addKeyListener(this);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        JScrollPane scrollpane = new JScrollPane(this.tree);
        this.getContentPane().add((Component)scrollpane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("App");
        menuBar.add(menu);
        JMenuItem mi = new JMenuItem("IoTP\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u78ba\u8a8d");
        mi.addActionListener(ae -> JOptionPane.showMessageDialog(this, "IoTP Launcher v" + version));
        menu.add(mi);
        mi = new JMenuItem("\u6700\u65b0\u7248\u304c\u3042\u308b\u304b\u30c1\u30a7\u30c3\u30af");
        mi.addActionListener(ae -> this.downloadLatest());
        menu.add(mi);
        mi = new JMenuItem("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30b5\u30a4\u30c8\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304f");
        mi.addActionListener(ae -> this.openURL(App.downloadurl));
        menu.add(mi);
        mi = new JMenuItem("\u5b9f\u884cJAR\u30d5\u30a1\u30a4\u30eb\u306e\u5834\u6240\u3092\u30a8\u30af\u30b9\u30d7\u30ed\u30fc\u30e9\u3067\u958b\u304f");
        mi.addActionListener(ae -> this.openExecPath());
        menu.add(mi);
        mi = new JMenuItem("\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u518d\u8d77\u52d5\u3059\u308b");
        mi.addActionListener(ae -> this.restart());
        menu.add(mi);
        mi = new JMenuItem("\u7d42\u4e86");
        mi.addActionListener(ae -> System.exit(0));
        menu.add(mi);
        this.serialMenu = new JMenu("Serial");
        menuBar.add(this.serialMenu);
        menu = new JMenu("File");
        menuBar.add(menu);
        mi = new JMenuItem("reload filetree");
        mi.addActionListener(ae -> this.reloadFiles());
        menu.add(mi);
        mi = new JMenuItem("\u30b5\u30f3\u30d7\u30eb\u30b3\u30fc\u30c9\u306e\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304f");
        mi.addActionListener(ae -> this.openWorkingDir());
        menu.add(mi);
        mi = new JMenuItem("FactoryTest\u3092\u66f8\u304d\u8fbc\u3080");
        mi.addActionListener(ae -> this.uploadFactoryTest());
        menu.add(mi);
        boolean isEnglish = false;
        menu = new JMenu(isEnglish ? "Help" : "\u30d8\u30eb\u30d7");
        menuBar.add(menu);
        mi = new JMenuItem(isEnglish ? "Usage" : "\u3064\u304b\u3044\u304b\u305f");
        mi.addActionListener(ae -> this.openURL("https://ss.istlab.info/presens/dview/395/"));
        menu.add(mi);
        mi = new JMenuItem(isEnglish ? "open Website" : "\u5b9f\u9a13Web\u30b5\u30a4\u30c8");
        mi.addActionListener(ae -> this.openURL("https://cit.istlab.info/m5stickcplus/index.html"));
        menu.add(mi);
        mi = new JMenuItem(isEnglish ? "MQTT Client" : "MQTT\u30af\u30e9\u30a4\u30a2\u30f3\u30c8");
        mi.addActionListener(ae -> MqttWindow.create().setVisible(true));
        menu.add(mi);
        this.setJMenuBar(menuBar);
        this.setSize(310, 600);
        this.setLocation(SerialWindow.leftOfScreen(this.getSize()));
        this.serialChecker = new SerialChecker(this);
    }

    void updateSerialMenu(ArrayList<String> validSerialNames) {
        this.serialMenu.removeAll();
        JMenuItem mi = new JMenuItem("\u30b7\u30ea\u30a2\u30eb\u30e2\u30cb\u30bf\u3092\u958b\u304f");
        mi.addActionListener(ae -> SerialWindow.invoke(true));
        this.serialMenu.add(mi);
        if (validSerialNames.size() > 0) {
            this.serialMenu.addSeparator();
            JMenuItem label = new JMenuItem("\u4f7f\u7528\u3059\u308b\u30b7\u30ea\u30a2\u30eb\u30dd\u30fc\u30c8\u3092\u9078\u629e");
            label.setEnabled(false);
            this.serialMenu.add(label);
        }
        boolean hasCurrent = false;
        if (validSerialNames.size() == 0) {
            App.serialName = null;
        } else if (validSerialNames.size() == 1) {
            App.serialName = validSerialNames.get(0);
        } else {
            String currentName = App.serialName;
            for (String s : validSerialNames) {
                if (!s.equals(currentName)) continue;
                hasCurrent = true;
            }
            if (!hasCurrent) {
                App.serialName = validSerialNames.get(0);
            }
        }
        for (String s : validSerialNames) {
            JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(s);
            this.serialMenu.add(jcbmi);
            if (s.equals(App.serialName)) {
                jcbmi.setSelected(true);
                jcbmi.addActionListener(e -> this.dummychooseSerial(e));
                continue;
            }
            jcbmi.addActionListener(e -> this.chooseSerial(e));
        }
        this.serialMenu.addSeparator();
        mi = new JMenuItem("\u30b7\u30ea\u30a2\u30eb\u30e2\u30cb\u30bf\u3092\u3059\u3079\u3066\u9589\u3058\u308b");
        mi.addActionListener(ae -> SerialWindow.disposeAll());
        this.serialMenu.add(mi);
        mi = new JMenuItem("\u30b7\u30ea\u30a2\u30eb\u30e2\u30cb\u30bf\u3092\u3059\u3079\u3066\u958b\u304f");
        mi.addActionListener(ae -> SerialWindow.openAll());
        this.serialMenu.add(mi);
    }

    void dummychooseSerial(ActionEvent e) {
        JCheckBoxMenuItem mi = (JCheckBoxMenuItem)e.getSource();
        mi.setSelected(true);
    }

    void chooseSerial(ActionEvent e) {
        App.serialName = e.getActionCommand();
        this.updateSerialMenu(this.serialChecker.validSerialNames);
    }

    public void renameOrDeleteNWPFolder() {
        int res = JOptionPane.showConfirmDialog(this, "NWP\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3059\u308b\u306a\u3089\u300c\u3044\u3044\u3048\u300d\u3001\u300eNWP_\u65e5\u4ed8_\u6642\u523b\u300f\u306b\u30d5\u30a9\u30eb\u30c0\u540d\u3092\u5909\u66f4\u3059\u308b\u306a\u3089\u300c\u306f\u3044\u300d\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        if (res == 0) {
            this.reloadFiles();
        } else if (res == 1) {
            this.reloadFiles();
        }
    }

    public void runCommand(String cmd, String chdir) {
        System.out.println(cmd);
        new CommandRunner(cmd, chdir).startstop();
    }

    public void stopProcess(boolean isAll) {
        ArrayList<Process> toberemoved = new ArrayList<Process>();
        for (Process proc : allProcs) {
            if (!isAll && proc.isAlive()) continue;
            proc.destroyForcibly();
            toberemoved.add(proc);
        }
        for (Process delproc : toberemoved) {
            allProcs.remove(delproc);
            Enumeration enu = JTAConsole.winStack.elements();
            while (enu.hasMoreElements()) {
                JTAConsole con = (JTAConsole)enu.nextElement();
                con.windowClosing(null);
                con.frame.dispose();
            }
        }
    }

    public void reloadFiles() {
        FileTreeModel model = new FileTreeModel(this.root, false);
        this.tree.setModel(model);
    }

    public void downloadLatest() {
        boolean isLatest = App.isLatest();
        if (isLatest) {
            JOptionPane.showMessageDialog(this, "\u6700\u65b0\u7248\u3067\u3059 : v" + version + "\n(download folder: " + App.execPath.getParent().toString() + ")");
        } else {
            int res = JOptionPane.showConfirmDialog(this, "\u6700\u65b0\u7248 \n(" + App.latestVersion + ") \u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3059\u308b?\n(download folder: " + App.execPath.getParent().toString() + ")");
            if (res == 0) {
                String execjarfilename = App.download();
                this.openExecPath();
                App.reboot(execjarfilename);
            }
        }
    }

    public void openWorkingDir() {
        this.openFolder(new File(App.workingDir));
    }

    public void openExecPath() {
        this.openFolder(App.execPath.getParent().toFile());
    }

    public void restart() {
        reboot_msec = 0;
        App.reboot(App.execPath.toString());
    }

    public void openFolder(File path) {
        try {
            Desktop.getDesktop().open(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openURL(String url) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.openEditor();
        }
    }

    private void openEditor() {
        TreePath tp = this.tree.getSelectionModel().getSelectionPath();
        if (tp == null) {
            return;
        }
        File node = (File)tp.getLastPathComponent();
        if (node.isDirectory()) {
            return;
        }
        Editor ed = this.file2editor.get(node);
        if (ed == null) {
            ed = new Editor(node);
            this.file2editor.put(node, ed);
        } else {
            ed.setVisible(true);
            ed.toFront();
        }
        System.out.println(node.toString());
    }

    private void uploadFactoryTest() {
        new ScriptRunner("_Upload_FactoryTest", null).startstop();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.openEditor();
        }
        if (e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) {
            if (e.getKeyCode() == 81) {
                System.exit(0);
            }
            if (e.getKeyCode() == 87) {
                System.exit(0);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void run() {
        try {
            Thread.sleep(reboot_msec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void updateTitle(String string) {
        this.setTitle("IoTP v" + version + " " + string);
    }

    static {
        version = "0.53";
        reboot_msec = 2000;
        allProcs = new ArrayList();
    }
}

