/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class FileReadWriter {
    public static ArrayList<String> getLinesListFromResource(String path) {
        ClassLoader cl = FileReadWriter.class.getClassLoader();
        if (cl == null) {
            System.err.println("Resource not found: " + path);
            return null;
        }
        InputStream ris = cl.getResourceAsStream(path);
        return FileReadWriter.getLinesListFromInputStream(ris, path);
    }

    public static ArrayList<String> getLinesListFromInputStream(InputStream is, String name) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName("utf-8")));
            String line = null;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            br.close();
        }
        catch (IOException err) {
            System.out.println("ReadError: " + name);
        }
        return list;
    }

    public static ArrayList<String> getLinesList(String fn, boolean createIfNotExist) {
        File f = new File(fn);
        if (createIfNotExist && !f.exists()) {
            try {
                if (f.createNewFile()) {
                    System.out.println("New file " + fn + " Created.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return FileReadWriter.getLinesList(fn);
    }

    public static ArrayList<String> getLinesList(String fn) {
        try {
            return FileReadWriter.getLinesListFromInputStream(new FileInputStream(fn), fn);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getLines(String fn) {
        ArrayList<String> list = FileReadWriter.getLinesList(fn);
        return list.toArray(new String[list.size()]);
    }

    public static String getLinesAsString(String fn) {
        ArrayList<String> list = FileReadWriter.getLinesList(fn);
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(s + "\n");
        }
        return sb.toString();
    }

    public static String[] getLinesFromResource(String path) {
        ArrayList<String> list = FileReadWriter.getLinesListFromResource(path);
        return list.toArray(new String[list.size()]);
    }

    public static void putLines(String fn, String[] data) {
        try {
            FileWriter filewriter = new FileWriter(fn, false);
            for (int i = 0; i < data.length; ++i) {
                filewriter.write(data[i]);
            }
            filewriter.close();
        }
        catch (IOException e) {
            System.out.println("WriteError:" + fn);
        }
    }

    public static void putLines(String fn, ArrayList<String> data) {
        try {
            FileWriter filewriter = new FileWriter(fn, false);
            for (String d : data) {
                d = d + "\r\n";
                filewriter.write(d);
            }
            filewriter.close();
        }
        catch (IOException e) {
            System.out.println("WriteError:" + fn);
        }
    }

    public static void putLinesWithLineNum(String fn, ArrayList<String> data) {
        try {
            FileWriter filewriter = new FileWriter(fn, false);
            int lineNum = 0;
            for (String d : data) {
                filewriter.write(lineNum + "" + d + "\r\n");
                ++lineNum;
            }
            filewriter.close();
        }
        catch (IOException e) {
            System.out.println("WriteError:" + fn);
        }
    }

    public static void putStringToFile(String fn, String out) {
        try {
            FileWriter filewriter = new FileWriter(fn, false);
            filewriter.write(out);
            filewriter.close();
        }
        catch (IOException e) {
            System.out.println("WriteError:" + fn);
        }
    }

    public static String[] split(String delim, String text) {
        int index = -1;
        ArrayList<String> list = new ArrayList<String>();
        while ((index = text.indexOf(delim)) != -1) {
            list.add(text.substring(0, index));
            text = text.substring(index + delim.length());
        }
        list.add(text);
        String[] ret = list.toArray(new String[list.size()]);
        return ret;
    }

    public static void writeBytesToFile(String filepath, byte[] ba) {
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(filepath);
            dos = new DataOutputStream(fos);
            dos.write(ba);
            dos.close();
            ((OutputStream)fos).close();
        }
        catch (IOException iex) {
            iex.printStackTrace(System.out);
        }
    }

    public static byte[] readBytesFromFile(String path) {
        ByteArrayOutputStream varyBuf = new ByteArrayOutputStream();
        int LS = 1024;
        try {
            int b;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
            byte[] buf = new byte[1024];
            while ((b = in.read(buf, 0, buf.length)) != -1) {
                varyBuf.write(buf, 0, b);
            }
            varyBuf.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return varyBuf.toByteArray();
    }
}

