/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import info.istlab.IoTP.Launcher;
import info.istlab.IoTP.MqttPublisher;
import info.istlab.IoTP.MqttSubscriber;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttWindow
extends JFrame
implements ActionListener,
WindowListener,
MqttCallback,
Runnable,
KeyListener {
    static MqttWindow theMqttWindow;
    JTextField jtf;
    JTextArea jta;
    Thread thread;
    JTextField brokerjtf = new JTextField("mqtt.istlab.info", 30);
    JTextField brokerportjtf;
    JTextField topicjtf;
    JButton connectB;
    MqttSubscriber subscriber;

    public static MqttWindow create() {
        if (theMqttWindow != null) {
            return theMqttWindow;
        }
        theMqttWindow = new MqttWindow();
        return theMqttWindow;
    }

    public static void main(String[] args) {
        new MqttWindow();
    }

    public MqttWindow() {
        super("MQTT TestApp");
        this.brokerjtf.addKeyListener(this);
        this.brokerportjtf = new JTextField("1883", 10);
        this.brokerportjtf.addKeyListener(this);
        this.topicjtf = new JTextField("+");
        this.topicjtf.addKeyListener(this);
        this.connectB = new JButton("Connect");
        this.connectB.addKeyListener(this);
        this.connectB.addActionListener(e -> this.connect(e));
        JPanel settingP = new JPanel();
        settingP.setLayout(new BoxLayout(settingP, 1));
        JPanel v01p = new JPanel(new BorderLayout());
        v01p.setBorder(BorderFactory.createTitledBorder("Broker ( ex. mqtt.istlab.info ) and port ( ex. 1883 )"));
        v01p.add((Component)this.brokerjtf, "Center");
        v01p.add((Component)this.brokerportjtf, "East");
        settingP.add(v01p);
        JPanel v02p = new JPanel(new BorderLayout());
        v02p.setBorder(BorderFactory.createTitledBorder("Topic ( ex. jikken | jikken/A1han | jikken/+ )"));
        v02p.add(this.topicjtf);
        v02p.add((Component)this.connectB, "East");
        settingP.add(v02p);
        this.jtf = new JTextField("(\u3053\u3053\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3001\u5165\u529b\u3057\u3066\u3001Enter\u3092\u62bc\u3059\u3068\u3001publish\u3057\u307e\u3059)");
        this.jtf.addKeyListener(this);
        this.jtf.setForeground(Color.GRAY);
        this.jtf.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (MqttWindow.this.jtf.getText().equals("(\u3053\u3053\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3001\u5165\u529b\u3057\u3066\u3001Enter\u3092\u62bc\u3059\u3068\u3001publish\u3057\u307e\u3059)")) {
                    MqttWindow.this.jtf.setText("");
                    MqttWindow.this.jtf.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (MqttWindow.this.jtf.getText().isEmpty()) {
                    MqttWindow.this.jtf.setForeground(Color.GRAY);
                    MqttWindow.this.jtf.setText("(\u3053\u3053\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3001\u5165\u529b\u3057\u3066\u3001Enter\u3092\u62bc\u3059\u3068\u3001publish\u3057\u307e\u3059)");
                }
            }
        });
        this.jtf.setBackground(new Color(210, 255, 255));
        this.getContentPane().add((Component)settingP, "North");
        this.jta = new JTextArea();
        this.jta.addKeyListener(this);
        this.jta.setBackground(Color.lightGray);
        this.getContentPane().add((Component)new JScrollPane(this.jta), "Center");
        JPanel v03p = new JPanel(new BorderLayout());
        v03p.setBorder(BorderFactory.createTitledBorder("Publish to the topic (\u672a\u63a5\u7d9a\u3067\u3082Topic\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308c\u3070\u9001\u4fe1\u3067\u304d\u307e\u3059)"));
        v03p.add(this.jtf);
        this.getContentPane().add((Component)v03p, "South");
        this.setSize(600, 500);
        this.setLocation(MqttWindow.centerOfScreen(this.getSize()));
        SwingUtilities.invokeLater(() -> this.setVisible(true));
        this.setDefaultCloseOperation(0);
        this.jtf.addActionListener(this);
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.appendToJTA("\u307e\u3060\u63a5\u7d9a\u3057\u3066\u3044\u307e\u305b\u3093\u3002Topic\u3092\u8a2d\u5b9a\u3057\u3066Connect\u3092\u304a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
    }

    @Override
    public void run() {
        this.subscriber = new MqttSubscriber(this.brokerjtf.getText(), this.brokerportjtf.getText(), this.topicjtf.getText(), this);
        this.jta.setBackground(Color.YELLOW);
        this.appendToJTA("Try Connecting to broker : tcp://" + this.brokerjtf.getText() + ":" + this.brokerportjtf.getText() + "\n");
        try {
            this.subscriber.subscribe();
        }
        catch (InterruptedException | MqttException e1) {
            e1.printStackTrace();
            this.appendToJTA("\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n");
            this.jta.setBackground(Color.magenta);
            this.thread = null;
            this.subscriber = null;
            return;
        }
        this.appendToJTA("Connected.\n");
        this.jta.setBackground(Color.white);
        this.topicjtf.setEditable(false);
        this.connectB.setText("Disconnect");
    }

    private void connect(ActionEvent e) {
        if (e.getActionCommand().equals("Connect")) {
            if (this.thread != null) {
                JOptionPane.showMessageDialog(this, "\u307e\u3060\u63a5\u7d9a\u8a66\u884c\u4e2d\u3067\u3059...");
                return;
            }
            this.thread = new Thread(this);
            this.thread.start();
        } else if (e.getActionCommand().equals("Disconnect")) {
            try {
                this.subscriber.unsubscribe();
            }
            catch (InterruptedException | MqttException e1) {
                e1.printStackTrace();
            }
            finally {
                this.subscriber = null;
                this.appendToJTA("Disconnected.\n");
                this.jta.setBackground(Color.gray);
                this.topicjtf.setEditable(true);
            }
            this.connectB.setText("Connect");
            this.thread = null;
        }
    }

    void appendToJTA(String s) {
        if (this.jta == null) {
            return;
        }
        this.jta.append(s);
        int len = this.jta.getDocument().getLength();
        if (this.jta.getSelectedText() == null) {
            this.jta.setCaretPosition(len);
        }
    }

    public static Point centerOfScreen(Dimension winSize) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point((screenSize.width - winSize.width) / 2, (screenSize.height - winSize.height) / 2);
    }

    public static Point leftOfScreen(Dimension winSize) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(10, (screenSize.height - winSize.height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String message = e.getActionCommand();
        try {
            if (message.length() > 0) {
                String topic = this.topicjtf.getText();
                if (topic.contains("#") || topic.contains("+")) {
                    this.appendToJTA("Publish\u3059\u308b\u3068\u304d\u3001Topic \u306b\u30ef\u30a4\u30eb\u30c9\u30ab\u30fc\u30c9\u6587\u5b57 #+ \u3092\u542b\u3081\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                    return;
                }
                MqttPublisher publisher = new MqttPublisher(this.brokerjtf.getText(), this.topicjtf.getText());
                publisher.publish(message);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void closeWin() {
        if (this.subscriber != null) {
            try {
                this.subscriber.unsubscribe();
            }
            catch (InterruptedException | MqttException e1) {
                e1.printStackTrace();
            }
            finally {
                this.subscriber = null;
                this.appendToJTA("Disconnected.\n");
                this.jta.setBackground(Color.gray);
            }
        }
        theMqttWindow = null;
        this.connectB.setText("Connect");
        if (Launcher.theapp == null || !Launcher.theapp.isVisible()) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeWin();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.closeWin();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void connectionLost(Throwable cause) {
        System.out.println("Connection lost");
        System.exit(1);
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws MqttException {
        this.appendToJTA("Topic : " + topic + "  Message: " + new String(message.getPayload()) + "\n");
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
        throw new UnsupportedOperationException("Unimplemented method 'deliveryComplete'");
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) && e.getKeyCode() == 87) {
            this.closeWin();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

