/*
 * Decompiled with CFR 0.152.
 */
package info.istlab.IoTP;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import info.istlab.IoTP.App;
import info.istlab.IoTP.Launcher;
import info.istlab.IoTP.SerialChecker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SerialWindow
extends JFrame
implements SerialPortDataListener,
ActionListener,
Runnable,
WindowListener,
KeyListener {
    SerialPort sp;
    JTextField jtf;
    JTextArea jta;
    Thread thread;
    static SerialChecker serialChecker;
    public static Hashtable<String, SerialWindow> hash;
    static SerialWindow swin;

    public static void check(boolean popup_if_zero) {
        if (App.serialName == null || serialChecker == null) {
            serialChecker = Launcher.theapp.serialChecker;
            serialChecker.updateSerialNames();
        }
        if (SerialWindow.serialChecker.validSerialNames.size() == 0 && popup_if_zero) {
            JOptionPane.showMessageDialog(Launcher.theapp, "No available serial ports.");
        }
    }

    public static void invoke(boolean popup_if_zero) {
        if (serialChecker == null) {
            serialChecker = Launcher.theapp.serialChecker;
        }
        serialChecker.updateSerialNames();
        if (SerialWindow.serialChecker.validSerialNames.size() == 0) {
            if (popup_if_zero) {
                JOptionPane.showMessageDialog(Launcher.theapp, "No available serial ports.");
            }
            return;
        }
        swin = hash.get(App.serialName);
        if (swin == null) {
            SerialPort sp = SerialWindow.serialChecker.portHash.get(App.serialName);
            swin = new SerialWindow(sp);
        } else {
            SwingUtilities.invokeLater(() -> {
                swin.setVisible(true);
                swin.reconnect();
            });
        }
    }

    public SerialWindow(SerialPort _sp) {
        super("SerialMonitor " + _sp.getSystemPortName() + " (\u30dc\u30fc\u30ec\u30fc\u30c8:115200)");
        this.sp = _sp;
        this.sp.setBaudRate(115200);
        this.sp.addDataListener(this);
        System.out.println(this.sp.getSystemPortName());
        if (!this.sp.openPort()) {
            JOptionPane.showMessageDialog(Launcher.theapp, "\u4ed6\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u307e\u305f\u306f\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u30b7\u30ea\u30a2\u30eb\u30dd\u30fc\u30c8 " + this.sp.getSystemPortName() + " \u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002");
            System.out.println("Unable to open the port.");
            return;
        }
        hash.put(this.sp.getSystemPortName(), this);
        this.jtf = new JTextField("(\u3053\u3053\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3001\u5165\u529b\u3057\u3066\u3001Enter\u3092\u62bc\u3059\u3068\u3001\u30b7\u30ea\u30a2\u30eb\u9001\u4fe1\u3057\u307e\u3059)");
        this.jtf.setForeground(Color.GRAY);
        this.jtf.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SerialWindow.this.jtf.getText().equals("(\u3053\u3053\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3001\u5165\u529b\u3057\u3066\u3001Enter\u3092\u62bc\u3059\u3068\u3001\u30b7\u30ea\u30a2\u30eb\u9001\u4fe1\u3057\u307e\u3059)")) {
                    SerialWindow.this.jtf.setText("");
                    SerialWindow.this.jtf.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SerialWindow.this.jtf.getText().isEmpty()) {
                    SerialWindow.this.jtf.setForeground(Color.GRAY);
                    SerialWindow.this.jtf.setText("(\u3053\u3053\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3001\u5165\u529b\u3057\u3066\u3001Enter\u3092\u62bc\u3059\u3068\u3001\u30b7\u30ea\u30a2\u30eb\u9001\u4fe1\u3057\u307e\u3059)");
                }
            }
        });
        this.jtf.setBackground(new Color(210, 255, 255));
        this.getContentPane().add((Component)this.jtf, "North");
        this.jta = new JTextArea();
        this.getContentPane().add((Component)new JScrollPane(this.jta), "Center");
        this.setSize(500, 400);
        this.setLocation(SerialWindow.centerOfScreen(this.getSize()));
        SwingUtilities.invokeLater(() -> this.setVisible(true));
        this.setDefaultCloseOperation(0);
        this.jtf.addActionListener(this);
        this.addWindowListener(this);
        this.jta.requestFocus();
        this.jtf.addKeyListener(this);
        this.jta.addKeyListener(this);
    }

    @Override
    public int getListeningEvents() {
        return 0x10000001;
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        try {
            int evt = event.getEventType();
            if (evt == 1) {
                int bytesToRead = this.sp.bytesAvailable();
                if (bytesToRead == -1) {
                    System.out.println("-1 means port is closed.");
                    this.closeSerialPort("\u5207\u65ad\u3055\u308c\u307e\u3057\u305f");
                    return;
                }
                byte[] newData = new byte[bytesToRead];
                this.sp.readBytes(newData, bytesToRead);
                String s = new String(newData, "UTF8");
                this.appendToJTA(s);
            } else if (evt == 0x10000000) {
                System.out.println("Port disconnected.");
                this.closeSerialPort("\u5207\u65ad\u3055\u308c\u307e\u3057\u305f");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            this.closeSerialPort("\u5207\u65ad\u3055\u308c\u307e\u3057\u305f");
        }
    }

    void appendToJTA(String s) {
        if (this.jta == null) {
            return;
        }
        if (s.contains("waiting for download")) {
            this.closeSerialPort(null);
        }
        this.jta.append(s);
        int len = this.jta.getDocument().getLength();
        if (this.jta.getSelectedText() == null) {
            this.jta.setCaretPosition(len);
        }
    }

    public static Point centerOfScreen(Dimension winSize) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point((screenSize.width - winSize.width) / 2, (screenSize.height - winSize.height) / 2);
    }

    public static Point leftOfScreen(Dimension winSize) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(10, (screenSize.height - winSize.height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        System.out.println(action);
        try {
            String message = action + "\n";
            byte[] b = message.getBytes();
            System.out.println("send " + b.length + " bytes");
            this.sp.writeBytes(b, b.length);
            this.jtf.setText("");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    @Override
    public void run() {
        this.appendToJTA("(Waiting to reconnect.)\n");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.thread != null) {
            if (!this.sp.openPort()) {
                System.out.println("Unable to open the port.");
                return;
            }
            this.thread = null;
            this.appendToJTA("Reconnected.\n");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.disposeWin();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.disposeWin();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static void disposeAll() {
        ArrayList toberemoved = new ArrayList();
        hash.entrySet().forEach(ent -> {
            SerialWindow swin = (SerialWindow)ent.getValue();
            if (swin != null) {
                toberemoved.add(swin);
            }
        });
        for (SerialWindow swin : toberemoved) {
            swin.disposeWin();
        }
    }

    public static void openAll() {
        if (serialChecker == null) {
            serialChecker = Launcher.theapp.serialChecker;
        }
        SerialWindow.serialChecker.portHash.entrySet().forEach(ent -> {
            String key = (String)ent.getKey();
            SerialPort sp = (SerialPort)ent.getValue();
            if (hash.get(key) != null) {
                SerialWindow swin = hash.get(key);
                SwingUtilities.invokeLater(() -> {
                    swin.setVisible(true);
                    swin.reconnect();
                });
            } else {
                new SerialWindow(sp);
            }
        });
    }

    public static void disposeByName(String serialName) {
        for (String key : hash.keySet()) {
            SerialWindow swin;
            if (!key.equals(serialName) || (swin = hash.get(key)) == null) continue;
            swin.disposeWin();
        }
    }

    void closeSerialPort(String mes) {
        if (this.sp != null && this.sp.isOpen()) {
            System.out.println("close Serial Port");
            this.sp.closePort();
            this.jta.setBackground(Color.lightGray);
            if (mes == null) {
                this.appendToJTA("Upload\u306b\u5099\u3048\u3066\u3001\u5207\u65ad\u3057\u307e\u3057\u305f\u3002");
            } else {
                this.appendToJTA(mes);
            }
        }
    }

    public void reconnect() {
        this.sp.openPort();
        this.jta.setBackground(Color.white);
    }

    public void disposeWin() {
        this.closeSerialPort("\u30b7\u30ea\u30a2\u30eb\u30e2\u30cb\u30bf\u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u9589\u3058\u307e\u3059");
        hash.remove(this.sp.getSystemPortName());
        this.dispose();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) && e.getKeyCode() == 87) {
            this.closeSerialPort("\u30b7\u30ea\u30a2\u30eb\u30e2\u30cb\u30bf\u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u9589\u3058\u307e\u3059");
            this.disposeWin();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    static {
        hash = new Hashtable();
    }
}

