/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import istlab.KisoJikken.App;
import istlab.KisoJikken.Editor;
import istlab.KisoJikken.FileTreeModel;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.MouseInputListener;
import javax.swing.tree.TreePath;

public class Launcher
extends JFrame
implements MouseInputListener,
KeyListener {
    public static Launcher theapp;
    public static String version;
    JTree tree;
    Hashtable<File, Editor> file2editor;

    public Launcher(String[] args) {
        super("Kiso NWP Launcher v" + version);
        this.setDefaultCloseOperation(3);
        this.file2editor = new Hashtable();
        theapp = this;
        File root = args.length > 0 ? new File(args[0]) : new File(App.userhome + App.nwpsrc);
        FileTreeModel model = new FileTreeModel(root);
        this.tree = new JTree();
        this.tree.setModel(model);
        this.tree.addMouseListener(this);
        this.tree.addKeyListener(this);
        JScrollPane scrollpane = new JScrollPane(this.tree);
        this.getContentPane().add((Component)scrollpane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("App");
        JMenuItem mi = new JMenuItem("show Version");
        mi.addActionListener(ae -> JOptionPane.showMessageDialog(this, "Kiso NWP Launcher v" + version));
        menu.add(mi);
        mi = new JMenuItem("download Latest");
        mi.addActionListener(ae -> this.downloadLatest());
        menu.add(mi);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.setSize(400, 600);
    }

    public void downloadLatest() {
        try {
            System.out.println(Launcher.getApplicationPath(this.getClass()));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static Path getApplicationPath(Class<?> cls) throws URISyntaxException {
        ProtectionDomain pd = cls.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL location = cs.getLocation();
        URI uri = location.toURI();
        Path path = Paths.get(uri);
        return path;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.openEditor();
        }
    }

    private void openEditor() {
        TreePath tp = this.tree.getSelectionModel().getSelectionPath();
        if (tp == null) {
            return;
        }
        File node = (File)tp.getLastPathComponent();
        Editor ed = this.file2editor.get(node);
        if (ed == null) {
            ed = new Editor(node);
            this.file2editor.put(node, ed);
        } else {
            ed.setVisible(true);
            ed.toFront();
        }
        System.out.println(node.toString());
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.openEditor();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    static {
        version = "0.3";
    }
}

