/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import istlab.KisoJikken.Editor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class JTAConsole
extends JTextArea
implements Runnable,
WindowListener,
KeyListener {
    static Stack<JTAConsole> winStack = new Stack();
    JFrame frame;
    Process process;
    Thread thread;
    InputStream instream;
    InputStreamReader isreader;
    BufferedReader reader;
    OutputStream outstream;

    public JTAConsole(String title) {
        this.frame = new JFrame(title);
        this.frame.getContentPane().add(new JScrollPane(this));
        this.frame.setSize(500, 200);
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(1);
        this.frame.addWindowListener(this);
        if (winStack.size() > 0) {
            JTAConsole last = winStack.peek();
            if (last.isVisible()) {
                Point lastFrameP = last.frame.getLocationOnScreen();
                this.frame.setLocation(lastFrameP.x + 470, lastFrameP.y);
            }
        } else if (Editor.lastOpened != null) {
            Point lastEditorP = Editor.lastOpened.getLocationOnScreen();
            Dimension lastEditorD = Editor.lastOpened.getSize();
            this.frame.setLocation(lastEditorP.x, lastEditorP.y + lastEditorD.height);
        }
        this.addKeyListener(this);
        winStack.push(this);
    }

    public void Systemoutprintln(String s) {
        this.append(s + "\n");
        int len = this.getDocument().getLength();
        this.setCaretPosition(len);
    }

    public void startBR(Process proc) {
        this.process = proc;
        try {
            this.reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        this.outstream = this.process.getOutputStream();
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                this.Systemoutprintln(line);
            }
            this.process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.Systemoutprintln("=== end ===");
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                this.Systemoutprintln(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.Systemoutprintln("=== end ===");
    }

    public static void main(String[] arg) {
        ProcessBuilder processBuilder = new ProcessBuilder("ping", "localhost");
        Process process = null;
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JTAConsole con = new JTAConsole("Demo");
        con.startBR(process);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        try {
            if (this.outstream != null) {
                this.outstream.close();
            }
            if (this.instream != null) {
                this.instream.close();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.process.destroy();
        winStack.remove(this);
        this.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.sendLastLine();
        }
        if (e.getKeyCode() > 64 && e.getKeyCode() < 96) {
            if (e.isControlDown()) {
                System.out.print("CTRL+");
            }
            if (e.isAltDown()) {
                System.out.print("ALT+");
            }
            if (e.isAltGraphDown()) {
                System.out.print("AltGraph+");
            }
            if (e.isMetaDown()) {
                System.out.print("META+");
            }
            System.out.println(KeyEvent.getKeyText(e.getKeyCode()));
        }
        if ((e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) && (e.getKeyCode() == 67 || e.getKeyCode() == 68 || e.getKeyCode() == 87)) {
            this.windowClosing(null);
            this.frame.dispose();
        }
    }

    private void sendLastLine() {
        try {
            int start = this.getLineStartOffset(this.getLineCount() - 1);
            int end = this.getLineEndOffset(this.getLineCount() - 1);
            String lastLineText = this.getText(start, end - start) + "\n";
            byte[] sbyte = lastLineText.getBytes();
            this.outstream.write(sbyte);
            this.outstream.flush();
        }
        catch (IOException | BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

