/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import istlab.KisoJikken.App;
import istlab.KisoJikken.Editor;
import istlab.KisoJikken.FileTreeModel;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.MouseInputListener;
import javax.swing.tree.TreePath;

public class Launcher
extends JFrame
implements MouseInputListener,
KeyListener {
    public static Launcher theapp;
    public static String version;
    public static String downloadurl;
    public static Path execPath;
    JTree tree;
    Hashtable<File, Editor> file2editor;

    public Launcher(String[] args) {
        super("Kiso NWP Launcher v" + version);
        this.setDefaultCloseOperation(3);
        this.file2editor = new Hashtable();
        theapp = this;
        try {
            execPath = Launcher.getApplicationPath(this.getClass());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        File root = args.length > 0 ? new File(args[0]) : new File(App.userhome + App.nwpsrc);
        FileTreeModel model = new FileTreeModel(root);
        this.tree = new JTree();
        this.tree.setModel(model);
        this.tree.addMouseListener(this);
        this.tree.addKeyListener(this);
        JScrollPane scrollpane = new JScrollPane(this.tree);
        this.getContentPane().add((Component)scrollpane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("App");
        JMenuItem mi = new JMenuItem("show version");
        mi.addActionListener(ae -> JOptionPane.showMessageDialog(this, "Kiso NWP Launcher v" + version));
        menu.add(mi);
        mi = new JMenuItem("download latest");
        mi.addActionListener(ae -> this.downloadLatest());
        menu.add(mi);
        mi = new JMenuItem("open download site");
        mi.addActionListener(ae -> this.openURL(downloadurl));
        menu.add(mi);
        mi = new JMenuItem("open JAR folder");
        mi.addActionListener(ae -> this.openExecPath());
        menu.add(mi);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.setSize(400, 600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadLatest() {
        StringBuilder sb = new StringBuilder();
        String latestVersion = null;
        try {
            URL url = new URL(downloadurl);
            InputStream is = url.openConnection().getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (latestVersion == null) {
                    latestVersion = line.trim();
                }
                System.out.println(line);
                sb.append(line + "\n");
            }
            reader.close();
        }
        catch (Exception url) {
            // empty catch block
        }
        System.out.println("[" + latestVersion + "]");
        System.out.println("=" + execPath.getFileName() + "=");
        if (latestVersion.equals(execPath.getFileName().toString())) {
            JOptionPane.showMessageDialog(this, "This is latest version : v" + version);
        } else {
            int res = JOptionPane.showConfirmDialog(this, "Download " + latestVersion + "??");
            if (res == 0) {
                try {
                    URL url = new URL(downloadurl + "/" + latestVersion);
                    ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
                    FileOutputStream fileOutputStream = new FileOutputStream(latestVersion);
                    FileChannel fileChannel = fileOutputStream.getChannel();
                    fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                    fileChannel.close();
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                this.openExecPath();
            }
        }
    }

    public void openExecPath() {
        File execFolder = execPath.getParent().toFile();
        this.openFolder(execFolder);
    }

    public void openFolder(File path) {
        try {
            Desktop.getDesktop().open(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openURL(String url) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    public static Path getApplicationPath(Class<?> cls) throws URISyntaxException {
        ProtectionDomain pd = cls.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL location = cs.getLocation();
        URI uri = location.toURI();
        Path path = Paths.get(uri);
        return path;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.openEditor();
        }
    }

    private void openEditor() {
        TreePath tp = this.tree.getSelectionModel().getSelectionPath();
        if (tp == null) {
            return;
        }
        File node = (File)tp.getLastPathComponent();
        Editor ed = this.file2editor.get(node);
        if (ed == null) {
            ed = new Editor(node);
            this.file2editor.put(node, ed);
        } else {
            ed.setVisible(true);
            ed.toFront();
        }
        System.out.println(node.toString());
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.openEditor();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    static {
        version = "0.4";
        downloadurl = "https://cit.istlab.info/KisoJikkenNWP/target/";
    }
}

