/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import istlab.KisoJikken.Launcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class App {
    public static String userhome;
    public static String nwpsrc;
    public static String gitrepos;
    public static String latestVersion;
    public static Path execPath;
    public static String downloadurl;

    public static void main(String[] args) {
        try {
            execPath = App.getApplicationPath(new App().getClass());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (!App.isLatest()) {
            int res;
            System.out.println("Different! " + latestVersion + " from " + execPath.getFileName().toString());
            String pathfile = App.download();
            if (pathfile != null && (res = JOptionPane.showConfirmDialog(null, "\u6700\u65b0\u7248\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002\u6700\u65b0\u7248\u3092\u8d77\u52d5\u3057\u307e\u3059\u304b\uff1f", "\u30a2\u30d7\u30ea\u66f4\u65b0", 0)) == 0) {
                App.reboot(pathfile);
            }
        }
        userhome = System.getProperty("user.home");
        App.getNWPifnotexist(false);
        SwingUtilities.invokeLater(() -> {
            try {
                String laf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Launcher(args).setVisible(true);
        });
    }

    public static Path getApplicationPath(Class<?> cls) throws URISyntaxException {
        ProtectionDomain pd = cls.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL location = cs.getLocation();
        URI uri = location.toURI();
        Path path = Paths.get(uri);
        return path;
    }

    public static boolean isLatest() {
        StringBuilder sb = new StringBuilder();
        latestVersion = null;
        try {
            URL url = new URL(downloadurl);
            InputStream is = url.openConnection().getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (latestVersion == null) {
                    latestVersion = line.trim();
                    System.out.println(line);
                }
                sb.append(line + "\n");
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (execPath.getFileName().toString().equals("classes")) {
            return true;
        }
        return latestVersion.equals(execPath.getFileName().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String download() {
        try {
            URL url = new URL(downloadurl + "/" + latestVersion);
            ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(latestVersion);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            fileChannel.close();
            fileOutputStream.close();
            File execjar = new File(execPath.getParent().toString() + File.separator + latestVersion);
            execjar.setExecutable(true);
            String string = execjar.getAbsolutePath();
            return string;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    public static void reboot(String pathfile) {
        String com = "sleep 2 ; java -jar " + pathfile;
        System.out.println(com);
        ProcessBuilder processBuilder = new ProcessBuilder("bash", "-c", com);
        try {
            processBuilder.start();
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void getNWPifnotexist(boolean showMessageIfExist) {
        if (Files.notExists(Paths.get(userhome + nwpsrc, new String[0]), new LinkOption[0])) {
            int res = JOptionPane.showConfirmDialog(Launcher.theapp, "NWP\u5b9f\u9a13\u7528\u306e\u30d5\u30a1\u30a4\u30eb\u304c " + userhome + nwpsrc + " \u306b\u3042\u308a\u307e\u305b\u3093\u3002\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u307e\u3059\u304b\uff1f");
            if (res == 0) {
                System.out.println("cd ; git clone " + gitrepos + " \u3092\u5b9f\u884c\u3002");
                ProcessBuilder processBuilder = new ProcessBuilder("git", "clone", gitrepos);
                processBuilder.directory(new File(userhome));
                processBuilder.inheritIO();
                try {
                    Process process = processBuilder.start();
                    process.waitFor();
                }
                catch (IOException | InterruptedException e1) {
                    e1.printStackTrace();
                }
            } else {
                System.out.println("cd ; git clone " + gitrepos + " \u3092\u5b9f\u884c\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                System.exit(0);
            }
        } else if (showMessageIfExist) {
            JOptionPane.showMessageDialog(Launcher.theapp, "NWP\u5b9f\u9a13\u7528\u306e\u30d5\u30a1\u30a4\u30eb\u304c " + userhome + nwpsrc + " \u306b\u3059\u3067\u306b\u3042\u308b\u305f\u3081\u3001\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3057\u305f\u3002");
        }
    }

    static {
        nwpsrc = File.separator + "NWP" + File.separator + "src";
        gitrepos = "https://git.istlab.info/git/miura250/NWP.git";
        downloadurl = "https://cit.istlab.info/KisoJikkenNWP/target/";
    }
}

