/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import istlab.KisoJikken.App;
import istlab.KisoJikken.CommandRunner;
import istlab.KisoJikken.Editor;
import istlab.KisoJikken.FileTreeModel;
import istlab.KisoJikken.JTAConsole;
import istlab.KisoJikken.MyFile;
import istlab.KisoJikken.MyTreeCellRenderer;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.MouseInputListener;
import javax.swing.tree.TreePath;

public class Launcher
extends JFrame
implements MouseInputListener,
KeyListener {
    public static Launcher theapp;
    public static String version;
    File root;
    JTree tree;
    JCheckBoxMenuItem jcbmi;
    Hashtable<File, Editor> file2editor;
    public static ArrayList<Process> allProcs;

    public Launcher(String[] args) {
        super("Kiso NWP Launcher v" + version);
        this.setDefaultCloseOperation(3);
        this.file2editor = new Hashtable();
        theapp = this;
        this.root = args.length > 0 ? new MyFile(args[0]) : new MyFile(App.userhome + App.nwpsrc);
        FileTreeModel model = new FileTreeModel(this.root, false);
        this.tree = new JTree();
        this.tree.setModel(model);
        this.tree.addMouseListener(this);
        this.tree.addKeyListener(this);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        JScrollPane scrollpane = new JScrollPane(this.tree);
        this.getContentPane().add((Component)scrollpane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("App");
        menuBar.add(menu);
        JMenuItem mi = new JMenuItem("show version");
        mi.addActionListener(ae -> JOptionPane.showMessageDialog(this, "Kiso NWP Launcher v" + version));
        menu.add(mi);
        mi = new JMenuItem("\u6700\u65b0\u7248\u3092\u30c1\u30a7\u30c3\u30af");
        mi.addActionListener(ae -> this.downloadLatest());
        menu.add(mi);
        mi = new JMenuItem("open download site");
        mi.addActionListener(ae -> this.openURL(App.downloadurl));
        menu.add(mi);
        mi = new JMenuItem("open JAR folder");
        mi.addActionListener(ae -> this.openExecPath());
        menu.add(mi);
        mi = new JMenuItem("exit");
        mi.addActionListener(ae -> System.exit(0));
        menu.add(mi);
        menu = new JMenu("File");
        menuBar.add(menu);
        this.jcbmi = new JCheckBoxMenuItem("exclude class files from filetree");
        this.jcbmi.addItemListener(ae -> this.reloadFiles());
        menu.add(this.jcbmi);
        mi = new JMenuItem("reload filetree");
        mi.addActionListener(ae -> this.reloadFiles());
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("rename/delete NWP folder");
        mi.addActionListener(ae -> this.renameOrDeleteNWPFolder());
        menu.add(mi);
        mi = new JMenuItem("get NWP folder");
        mi.addActionListener(ae -> App.getNWPifnotexist(true));
        menu.add(mi);
        boolean isEnglish = false;
        menu = new JMenu(isEnglish ? "Process" : "\u30d7\u30ed\u30bb\u30b9");
        menuBar.add(menu);
        mi = new JMenuItem("stop alive");
        mi.addActionListener(ae -> this.stopProcess(false));
        menu.add(mi);
        mi = new JMenuItem("stop all");
        mi.addActionListener(ae -> this.stopProcess(true));
        menu.add(mi);
        mi = new JMenuItem("jps (Java\u306e\u30d7\u30ed\u30bb\u30b9\u78ba\u8a8d)");
        mi.addActionListener(ae -> this.runCommand(ae.getActionCommand(), null));
        menu.add(mi);
        mi = new JMenuItem("killall java (Java\u30d7\u30ed\u30bb\u30b9\u3092\u3059\u3079\u3066\u5f37\u5236\u7d42\u4e86)");
        mi.addActionListener(ae -> this.runCommand(ae.getActionCommand(), null));
        menu.add(mi);
        menu = new JMenu(isEnglish ? "Help" : "\u30d8\u30eb\u30d7");
        menuBar.add(menu);
        mi = new JMenuItem(isEnglish ? "Usage" : "\u3064\u304b\u3044\u304b\u305f");
        mi.addActionListener(ae -> this.openURL("https://ss.istlab.info/presens/dview/383/"));
        menu.add(mi);
        this.setJMenuBar(menuBar);
        this.setSize(310, 600);
    }

    public void renameOrDeleteNWPFolder() {
        int res = JOptionPane.showConfirmDialog(this, "NWP\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3059\u308b\u306a\u3089\u300c\u3044\u3044\u3048\u300d\u3001\u300eNWP_\u65e5\u4ed8_\u6642\u523b\u300f\u306b\u30d5\u30a9\u30eb\u30c0\u540d\u3092\u5909\u66f4\u3059\u308b\u306a\u3089\u300c\u306f\u3044\u300d\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        if (res == 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd_HHmm");
            this.runCommand("mv NWP NWP_" + sdf.format(new Date()), App.userhome);
            this.reloadFiles();
        } else if (res == 1) {
            this.runCommand("rm -fr ~/NWP", App.userhome);
            this.reloadFiles();
        }
    }

    public void runCommand(String cmd, String chdir) {
        System.out.println(cmd);
        new CommandRunner(cmd, chdir).startstop();
    }

    public void stopProcess(boolean isAll) {
        ArrayList<Process> toberemoved = new ArrayList<Process>();
        for (Process proc : allProcs) {
            if (!isAll && proc.isAlive()) continue;
            proc.destroyForcibly();
            toberemoved.add(proc);
        }
        for (Process delproc : toberemoved) {
            allProcs.remove(delproc);
            Enumeration enu = JTAConsole.winStack.elements();
            while (enu.hasMoreElements()) {
                JTAConsole con = (JTAConsole)enu.nextElement();
                con.windowClosing(null);
                con.frame.dispose();
            }
        }
    }

    public void reloadFiles() {
        FileTreeModel model = new FileTreeModel(this.root, this.jcbmi.isSelected());
        this.tree.setModel(model);
    }

    public void downloadLatest() {
        boolean isLatest = App.isLatest();
        if (isLatest) {
            JOptionPane.showMessageDialog(this, "\u3059\u3067\u306b\u6700\u65b0\u7248\u3067\u3059 : v" + version + "\n(download folder: " + App.execPath.getParent().toString() + ")");
        } else {
            int res = JOptionPane.showConfirmDialog(this, "\u6700\u65b0\u7248 \n(" + App.latestVersion + ") \u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3059\u308b?\n(download folder: " + App.execPath.getParent().toString() + ")");
            if (res == 0) {
                App.download();
                this.openExecPath();
            }
        }
    }

    public void openExecPath() {
        File execFolder = App.execPath.getParent().toFile();
        this.openFolder(execFolder);
    }

    public void openFolder(File path) {
        try {
            Desktop.getDesktop().open(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openURL(String url) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.openEditor();
        }
    }

    private void openEditor() {
        TreePath tp = this.tree.getSelectionModel().getSelectionPath();
        if (tp == null) {
            return;
        }
        File node = (File)tp.getLastPathComponent();
        if (node.isDirectory()) {
            return;
        }
        Editor ed = this.file2editor.get(node);
        if (ed == null) {
            ed = new Editor(node);
            this.file2editor.put(node, ed);
        } else {
            ed.setVisible(true);
            ed.toFront();
        }
        System.out.println(node.toString());
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.openEditor();
        }
        if (e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) {
            if (e.getKeyCode() == 81) {
                System.exit(0);
            }
            if (e.getKeyCode() == 87) {
                System.exit(0);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    static {
        version = "0.75";
        allProcs = new ArrayList();
    }
}

