/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import istlab.KisoJikken.App;
import istlab.KisoJikken.JCompiler;
import istlab.KisoJikken.JExecutor;
import istlab.KisoJikken.Launcher;
import istlab.KisoJikken.ScriptRunner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class Editor
extends JFrame
implements ActionListener,
KeyListener {
    static Editor lastOpened;
    File file;
    RSyntaxTextArea textArea;
    JPanel topP;
    JSlider fontSizeJS;
    JButton saveB;
    JButton runB;
    JButton compileB;
    JButton execB;
    JTextField comlineOption;
    ScriptRunner runner;

    public Editor(File f) {
        this.file = f;
        this.textArea = new RSyntaxTextArea(20, 40);
        this.textArea.setFont(new FontUIResource("sansserif", 0, 16));
        this.getContentPane().add(new RTextScrollPane(this.textArea));
        this.textArea.addKeyListener(this);
        try {
            this.setTitle(this.file.getCanonicalPath().replaceAll(App.userhome_escaped, "~"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setSize(new Dimension(800, 400));
        this.setLocationRelativeTo(Launcher.theapp);
        this.setLocation(Launcher.theapp.getWidth(), Launcher.theapp.file2editor.size() * 40);
        this.setDefaultCloseOperation(1);
        this.load();
        this.topP = new JPanel();
        this.topP.setLayout(new FlowLayout(1, 1, 2));
        this.topP.add(new JLabel("size:"));
        this.fontSizeJS = new JSlider(10, 50, 16);
        this.topP.add(this.fontSizeJS);
        this.fontSizeJS.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int size = Editor.this.fontSizeJS.getValue();
                Editor.this.textArea.setFont(new FontUIResource("sansserif", 0, size));
            }
        });
        this.saveB = new JButton("Save");
        this.saveB.addActionListener(this);
        this.saveB.setEnabled(false);
        if (this.file.getName().endsWith(".java")) {
            this.textArea.setSyntaxEditingStyle("text/java");
            this.textArea.setCodeFoldingEnabled(true);
            this.topP.add(this.saveB);
        } else if (this.file.getName().endsWith(".sh")) {
            this.textArea.setSyntaxEditingStyle("text/unix");
            this.topP.add(this.saveB);
        } else if (this.file.getName().endsWith(".class")) {
            this.textArea.setEditable(false);
        } else {
            this.topP.add(this.saveB);
        }
        JButton loadB = new JButton("Reload");
        loadB.addActionListener(this);
        this.topP.add(loadB);
        if (this.textArea.getSyntaxEditingStyle() == "text/unix") {
            this.runB = new JButton("Run");
            this.runB.addActionListener(this);
            this.topP.add(this.runB);
            this.runner = new ScriptRunner(this.file.getAbsolutePath(), this.runB);
        } else if (this.textArea.getSyntaxEditingStyle() == "text/java") {
            this.compileB = new JButton("Compile");
            this.execB = new JButton("Exec");
            this.compileB.addActionListener(this);
            this.execB.addActionListener(this);
            this.topP.add(this.compileB);
            this.topP.add(this.execB);
            this.comlineOption = new JTextField("arg1 arg2 ...", 15);
            this.comlineOption.setForeground(Color.GRAY);
            this.comlineOption.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (Editor.this.comlineOption.getText().equals("arg1 arg2 ...")) {
                        Editor.this.comlineOption.setText("");
                        Editor.this.comlineOption.setForeground(Color.BLACK);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (Editor.this.comlineOption.getText().isEmpty()) {
                        Editor.this.comlineOption.setForeground(Color.GRAY);
                        Editor.this.comlineOption.setText("arg1 arg2 ...");
                    }
                }
            });
            this.topP.add(this.comlineOption);
        }
        this.getContentPane().add((Component)this.topP, "North");
        this.setVisible(true);
        this.textArea.requestFocus();
        this.textArea.setCaretPosition(0);
        lastOpened = this;
    }

    public static String loadFile(File f) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return sb.toString();
    }

    public void load() {
        this.textArea.setText(Editor.loadFile(this.file));
    }

    public void save() {
        String src = this.textArea.getText();
        try {
            PrintWriter out = new PrintWriter(this.file.getAbsolutePath(), "UTF-8");
            out.println(src);
            out.flush();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println("\u4fdd\u5b58\u3057\u307e\u3057\u305f");
        this.saveB.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Save")) {
            this.save();
        } else if (e.getActionCommand().equals("Reload")) {
            this.load();
        } else if (e.getActionCommand().equals("Run")) {
            this.runner.startstop();
            this.runB.setText("Stop");
        } else if (e.getActionCommand().equals("Stop")) {
            this.runner.startstop();
            this.runB.setText("Run");
        } else if (e.getActionCommand().equals("Compile")) {
            new JCompiler(this.file.getAbsolutePath());
        } else if (e.getActionCommand().equals("Exec")) {
            new JExecutor(this.file.getAbsolutePath(), this.comlineOption.getText());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.saveB.setEnabled(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        System.out.println(e.getKeyCode());
        if (e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) {
            if (e.getKeyCode() == 83) {
                this.save();
            }
            if (e.getKeyCode() == 87) {
                this.setVisible(false);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

