/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import istlab.KisoJikken.Editor;
import istlab.KisoJikken.JTAConsolePopup;
import istlab.KisoJikken.Launcher;
import istlab.KisoJikken.MyRSJTextArea;
import istlab.KisoJikken.PostHTTP;
import istlab.KisoJikken.SendJsonData;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;

public class JTAConsole
extends MyRSJTextArea
implements Runnable,
WindowListener,
KeyListener,
MouseListener,
ActionListener {
    static Stack<JTAConsole> winStack = new Stack();
    JFrame frame;
    Process process;
    Thread thread;
    InputStream instream;
    InputStreamReader isreader;
    BufferedReader reader;
    OutputStream outstream;
    StringBuilder originalContent;
    String mainSrc;

    public JTAConsole(String title) {
        this(title, 200);
    }

    public JTAConsole(String title, int win_height) {
        this.frame = new JFrame(title);
        this.frame.getContentPane().add(new JScrollPane(this));
        this.frame.setSize(500, win_height);
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(1);
        this.frame.addWindowListener(this);
        if (winStack.size() > 0) {
            JTAConsole last = winStack.peek();
            if (last.isVisible()) {
                Point lastFrameP = last.frame.getLocationOnScreen();
                this.frame.setLocation(lastFrameP.x + 470, lastFrameP.y);
            }
        } else if (Editor.lastOpened != null) {
            Point lastEditorP = Editor.lastOpened.getLocationOnScreen();
            Dimension lastEditorD = Editor.lastOpened.getSize();
            this.frame.setLocation(lastEditorP.x, lastEditorP.y + lastEditorD.height);
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        winStack.push(this);
        this.originalContent = new StringBuilder();
    }

    public void Systemoutprintln(String s) {
        this.append(s + "\n");
        this.originalContent.append(s + "\n");
        int len = this.getDocument().getLength();
        if (this.getSelectedText() == null) {
            this.setCaretPosition(len);
        }
    }

    public void startBR(Process proc) {
        this.process = proc;
        try {
            this.reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        this.outstream = this.process.getOutputStream();
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                this.Systemoutprintln(line);
            }
            this.process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            System.out.print(e.getClass().getCanonicalName() + " : ");
            System.out.println(e.getLocalizedMessage());
        }
        this.Systemoutprintln("=== end ===");
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                this.Systemoutprintln(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.Systemoutprintln("=== end ===");
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void destroyProcess() {
        try {
            if (this.outstream != null) {
                this.outstream.close();
            }
            if (this.instream != null) {
                this.instream.close();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.process.destroyForcibly();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.destroyProcess();
        winStack.remove(this);
        this.setVisible(false);
        if (!this.process.isAlive()) {
            Launcher.allProcs.remove(this.process);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.sendLastLine();
        }
        if (e.getKeyCode() > 64 && e.getKeyCode() < 96) {
            if (e.isControlDown()) {
                System.out.print("CTRL+");
                System.out.println(KeyEvent.getKeyText(e.getKeyCode()));
            }
            if (e.isAltDown()) {
                System.out.print("ALT+");
                System.out.println(KeyEvent.getKeyText(e.getKeyCode()));
            }
            if (e.isAltGraphDown()) {
                System.out.print("AltGraph+");
                System.out.println(KeyEvent.getKeyText(e.getKeyCode()));
            }
            if (e.isMetaDown()) {
                System.out.print("META+");
                System.out.println(KeyEvent.getKeyText(e.getKeyCode()));
            }
        }
        if (e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) {
            if (e.getKeyCode() == 67) {
                if (this.getSelectedText() != null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Clipboard clip = kit.getSystemClipboard();
                    StringSelection ss = new StringSelection(this.getSelectedText());
                    clip.setContents(ss, ss);
                    System.out.println("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
                } else {
                    this.destroyProcess();
                }
            }
            if (e.getKeyCode() == 68 || e.getKeyCode() == 87) {
                this.windowClosing(null);
                this.frame.dispose();
            }
        }
    }

    private void sendLastLine() {
        try {
            int start = this.getLineStartOffset(this.getLineCount() - 1);
            int end = this.getLineEndOffset(this.getLineCount() - 1);
            String lastLineText = this.getText(start, end - start) + "\n";
            byte[] sbyte = lastLineText.getBytes();
            this.outstream.write(sbyte);
            this.outstream.flush();
        }
        catch (IOException | BadLocationException e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            JTAConsolePopup popupMenu = new JTAConsolePopup(this);
            popupMenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block6: {
            String s;
            block7: {
                block5: {
                    if (!e.getActionCommand().equals("Copy")) break block5;
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Clipboard clip = kit.getSystemClipboard();
                    StringSelection ss = new StringSelection(this.getSelectedText());
                    clip.setContents(ss, ss);
                    break block6;
                }
                if (!e.getActionCommand().equals("Show Diff")) break block7;
                String orig = this.originalContent.toString();
                String buffer = this.getText();
                List<String> origList = Arrays.asList(orig.split("\n"));
                List<String> bufList = Arrays.asList(buffer.split("\n"));
                DiffRowGenerator generator = DiffRowGenerator.create().showInlineDiffs(true).inlineDiffByWord(true).oldTag(f -> "~").newTag(f -> "**").build();
                List<DiffRow> rows = generator.generateDiffRows(origList, bufList);
                System.out.println("|original|new|");
                System.out.println("|--------|---|");
                for (DiffRow row : rows) {
                    System.out.println("|" + row.getOldLine() + "|" + row.getNewLine() + "|");
                }
                break block6;
            }
            if (!e.getActionCommand().equals("Submit")) break block6;
            if (SendJsonData.studentID == null && (s = JOptionPane.showInputDialog(this, (Object)"\u304a\u624b\u6570\u3067\u3059\u304c\u3001\u5b66\u751f\u756a\u53f7\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\uff08\u4f8b\uff1a21A5999\uff09")) != null) {
                SendJsonData.studentID = s.trim();
            }
            String orig = this.originalContent.toString();
            String buffer = this.getText();
            SendJsonData sjd = new SendJsonData(orig, buffer);
            if (this.mainSrc != null) {
                sjd.setMainSrc(this.mainSrc);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(sjd);
            PostHTTP postHttp = new PostHTTP(json);
            try {
                JOptionPane.showMessageDialog(this, postHttp.execute());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void setMainSrcByFileName(String absolutePath) {
        File f = new File(absolutePath);
        this.mainSrc = Editor.loadFile(f);
    }
}

