/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import istlab.KisoJikken.App;
import istlab.KisoJikken.CommandRunner;
import istlab.KisoJikken.Editor;
import istlab.KisoJikken.FileTreeModel;
import istlab.KisoJikken.GitManager;
import istlab.KisoJikken.JTAConsole;
import istlab.KisoJikken.MyFile;
import istlab.KisoJikken.MyTreeCellRenderer;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.MouseInputListener;
import javax.swing.tree.TreePath;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;

public class Launcher
extends JFrame
implements MouseInputListener,
KeyListener,
Runnable {
    public static Launcher theapp;
    public static String version;
    static int reboot_msec;
    File root;
    GitManager gitrepom;
    JTree tree;
    JCheckBoxMenuItem jcbmi;
    Hashtable<File, Editor> file2editor;
    public static ArrayList<Process> allProcs;

    public Launcher(String[] args) {
        super("Kiso NWP Launcher v" + version);
        this.setDefaultCloseOperation(3);
        this.file2editor = new Hashtable();
        theapp = this;
        this.root = args.length > 0 ? new MyFile(args[0]) : new MyFile(App.userhome + App.nwpsrc);
        try {
            this.gitrepom = new GitManager(this.root);
            this.gitrepom.checkClean(true);
        }
        catch (IOException | GitAPIException | NoWorkTreeException e) {
            e.printStackTrace();
        }
        FileTreeModel model = new FileTreeModel(this.root, false);
        this.tree = new JTree();
        this.tree.setModel(model);
        this.tree.addMouseListener(this);
        this.tree.addKeyListener(this);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        JScrollPane scrollpane = new JScrollPane(this.tree);
        this.getContentPane().add((Component)scrollpane, "Center");
        boolean isEnglish = false;
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(isEnglish ? "File" : "\u30d5\u30a1\u30a4\u30eb");
        menuBar.add(menu);
        this.jcbmi = new JCheckBoxMenuItem("class\u30d5\u30a1\u30a4\u30eb\u3092\u975e\u8868\u793a\u306b\u3059\u308b");
        this.jcbmi.addItemListener(ae -> this.reloadFiles());
        menu.add(this.jcbmi);
        JMenuItem mi = new JMenuItem("\u30d5\u30a1\u30a4\u30eb\u4e00\u89a7\u3092\u518d\u8aad\u307f\u8fbc\u307f");
        mi.addActionListener(ae -> this.reloadFiles());
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("NWP\u30d5\u30a9\u30eb\u30c0\u306e\u5909\u66f4\u72b6\u6cc1\u78ba\u8a8d");
        mi.addActionListener(ae -> {
            try {
                this.gitrepom.checkClean(false);
            }
            catch (NoWorkTreeException e) {
                e.printStackTrace();
            }
            catch (GitAPIException e) {
                e.printStackTrace();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Launcher\u3092\u518d\u8d77\u52d5\u3059\u308b");
        mi.addActionListener(ae -> this.restart());
        menu.add(mi);
        mi = new JMenuItem("Launcher\u3092\u7d42\u4e86");
        mi.addActionListener(ae -> System.exit(0));
        menu.add(mi);
        menu = new JMenu(isEnglish ? "Process" : "\u30d7\u30ed\u30bb\u30b9");
        menuBar.add(menu);
        mi = new JMenuItem("jps (Java\u306e\u30d7\u30ed\u30bb\u30b9\u78ba\u8a8d)");
        mi.addActionListener(ae -> this.runCommand(ae.getActionCommand(), null));
        menu.add(mi);
        mi = new JMenuItem("Java\u304c\u958b\u3044\u3066\u3044\u308b\u30dd\u30fc\u30c8\u306e\u78ba\u8a8d");
        mi.addActionListener(ae -> JOptionPane.showInputDialog(theapp, "Java\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u958b\u3044\u3066\u3044\u308b\u30dd\u30fc\u30c8\u3092\u78ba\u8a8d\u3059\u308b\u306b\u306f\n\u304a\u624b\u6570\u3067\u3059\u304c\u3001\u30bf\u30fc\u30df\u30ca\u30eb\u3067\u4ee5\u4e0b\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\n(\u30b3\u30d4\u30fc\u3057\u3084\u3059\u3055\u3092\u8003\u616e\u3057\u3001\u30c6\u30ad\u30b9\u30c8\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u8868\u793a\u3057\u3066\u3044\u307e\u3059)", "lsof -i -n -P | grep java"));
        menu.add(mi);
        mi = new JMenuItem("\u30a2\u30af\u30c6\u30a3\u30d6\u306aJava\u30d7\u30ed\u30bb\u30b9\u3092\u505c\u6b62");
        mi.addActionListener(ae -> this.stopProcess(false));
        menu.add(mi);
        mi = new JMenuItem("\u3059\u3079\u3066\u306eJava\u30d7\u30ed\u30bb\u30b9\u3092\u505c\u6b62");
        mi.addActionListener(ae -> this.stopProcess(true));
        menu.add(mi);
        mi = new JMenuItem("killall java (Java\u30d7\u30ed\u30bb\u30b9\u3092\u3059\u3079\u3066\u5f37\u5236\u7d42\u4e86)");
        mi.addActionListener(ae -> this.runCommand(ae.getActionCommand(), null));
        menu.add(mi);
        menu = new JMenu(isEnglish ? "Help" : "\u30d8\u30eb\u30d7");
        menuBar.add(menu);
        mi = new JMenuItem(isEnglish ? "Usage" : "\u3064\u304b\u3044\u304b\u305f");
        mi.addActionListener(ae -> this.openURL("https://ss.istlab.info/presens/dview/383/"));
        menu.add(mi);
        mi = new JMenuItem(isEnglish ? "LMS Login" : "\u8b1b\u7fa9\u30b7\u30b9\u30c6\u30e0 \u30ed\u30b0\u30a4\u30f3");
        mi.addActionListener(ae -> this.openURL("https://ss.istlab.info/users/login"));
        menu.add(mi);
        menu = new JMenu("App");
        menuBar.add(menu);
        mi = new JMenuItem("Launcher\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831\u3092\u8868\u793a");
        mi.addActionListener(ae -> JOptionPane.showMessageDialog(this, "Kiso NWP Launcher v" + version));
        menu.add(mi);
        mi = new JMenuItem("Launcher\u306e\u6700\u65b0\u7248\u3092\u30c1\u30a7\u30c3\u30af");
        mi.addActionListener(ae -> this.downloadLatest());
        menu.add(mi);
        mi = new JMenuItem("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30b5\u30a4\u30c8\u3092\u958b\u304f");
        mi.addActionListener(ae -> this.openURL(App.downloadurl));
        menu.add(mi);
        mi = new JMenuItem("JAR\u30d5\u30a1\u30a4\u30eb\u306e\u5834\u6240\u3092\u958b\u304f");
        mi.addActionListener(ae -> this.openExecPath());
        menu.add(mi);
        this.setJMenuBar(menuBar);
        this.setSize(310, 600);
    }

    public void renameOrDeleteNWPFolder() {
        int res = JOptionPane.showConfirmDialog(this, "NWP\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3059\u308b\u306a\u3089\u300c\u3044\u3044\u3048\u300d\u3001\u300eNWP_\u65e5\u4ed8_\u6642\u523b\u300f\u306b\u30d5\u30a9\u30eb\u30c0\u540d\u3092\u5909\u66f4\u3059\u308b\u306a\u3089\u300c\u306f\u3044\u300d\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        if (res == 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd_HHmm");
            this.runCommand("mv NWP NWP_" + sdf.format(new Date()), App.userhome);
            this.reloadFiles();
        } else if (res == 1) {
            this.runCommand("rm -fr ~/NWP", App.userhome);
            this.reloadFiles();
        }
    }

    public void restart() {
        reboot_msec = 0;
        App.reboot(App.execPath.toString());
    }

    public void runCommand(String cmd, String chdir) {
        System.out.println(cmd);
        new CommandRunner(cmd, chdir).startstop();
    }

    public void runCommand(String cmd, String chdir, int wheight) {
        System.out.println(cmd);
        new CommandRunner(cmd, chdir, wheight).startstop();
    }

    public void stopProcess(boolean isAll) {
        ArrayList<Process> toberemoved = new ArrayList<Process>();
        for (Process proc : allProcs) {
            if (!isAll && proc.isAlive()) continue;
            proc.destroyForcibly();
            toberemoved.add(proc);
        }
        for (Process delproc : toberemoved) {
            allProcs.remove(delproc);
            Enumeration enu = JTAConsole.winStack.elements();
            while (enu.hasMoreElements()) {
                JTAConsole con = (JTAConsole)enu.nextElement();
                con.windowClosing(null);
                con.frame.dispose();
            }
        }
    }

    public void reloadFiles() {
        FileTreeModel model = new FileTreeModel(this.root, this.jcbmi.isSelected());
        this.tree.setModel(model);
    }

    public void downloadLatest() {
        boolean isLatest = App.isLatest();
        if (isLatest) {
            JOptionPane.showMessageDialog(this, "\u3059\u3067\u306b\u6700\u65b0\u7248\u3067\u3059 : v" + version + "\n(download folder: " + App.execPath.getParent().toString() + ")");
        } else {
            int res = JOptionPane.showConfirmDialog(this, "\u6700\u65b0\u7248 \n(" + App.latestVersion + ") \u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3059\u308b?\n(download folder: " + App.execPath.getParent().toString() + ")");
            if (res == 0) {
                App.download();
                this.openExecPath();
            }
        }
    }

    public void openExecPath() {
        File execFolder = App.execPath.getParent().toFile();
        this.openFolder(execFolder);
    }

    public void openFolder(File path) {
        try {
            Desktop.getDesktop().open(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openURL(String url) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.openEditor();
        }
    }

    private void openEditor() {
        TreePath tp = this.tree.getSelectionModel().getSelectionPath();
        if (tp == null) {
            return;
        }
        File node = (File)tp.getLastPathComponent();
        if (node.isDirectory()) {
            return;
        }
        Editor ed = this.file2editor.get(node);
        if (ed == null) {
            ed = new Editor(node);
            this.file2editor.put(node, ed);
        } else {
            ed.setVisible(true);
            ed.toFront();
        }
        System.out.println(node.toString());
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.openEditor();
        }
        if (e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) {
            if (e.getKeyCode() == 81) {
                System.exit(0);
            }
            if (e.getKeyCode() == 87) {
                System.exit(0);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void run() {
        try {
            Thread.sleep(reboot_msec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    static {
        version = "0.77";
        reboot_msec = 2000;
        allProcs = new ArrayList();
    }
}

