/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken.Test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextScrollPane;

public final class SyntaxSchemeDemo
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private RSyntaxTextArea textArea;
    private static final String TEXT = "public class ExampleSource {\n\n   // Check out the crazy modified styles!\n   public static void main(String[] args) {\n      System.out.println(\"Hello, world!\");\n   }\n\n}\n";

    private SyntaxSchemeDemo() {
        JPanel cp = new JPanel(new BorderLayout());
        this.textArea = new RSyntaxTextArea(20, 60);
        this.textArea.setSyntaxEditingStyle("text/java");
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setAntiAliasingEnabled(true);
        RTextScrollPane sp = new RTextScrollPane(this.textArea);
        cp.add(sp);
        this.textArea.setText(TEXT);
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        mb.add(menu);
        JMenuItem changeStyleProgrammaticallyItem = new JMenuItem("Change Style Programmatically");
        changeStyleProgrammaticallyItem.setActionCommand("ChangeProgrammatically");
        changeStyleProgrammaticallyItem.addActionListener(this);
        menu.add(changeStyleProgrammaticallyItem);
        JMenuItem changeStyleViaThemesItem = new JMenuItem("Change Style via Theme XML");
        changeStyleViaThemesItem.setActionCommand("ChangeViaThemes");
        changeStyleViaThemesItem.addActionListener(this);
        menu.add(changeStyleViaThemesItem);
        this.setJMenuBar(mb);
        this.setContentPane(cp);
        this.setTitle("Syntax Scheme Demo");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("ChangeProgrammatically".equals(command)) {
            this.changeStyleProgrammatically();
        } else if ("ChangeViaThemes".equals(command)) {
            this.changeStyleViaThemeXml();
        }
    }

    private void changeStyleProgrammatically() {
        SyntaxSchemeDemo.setFont(this.textArea, new Font("Comic Sans MS", 0, 16));
        SyntaxScheme scheme = this.textArea.getSyntaxScheme();
        scheme.getStyle((int)6).background = Color.pink;
        scheme.getStyle((int)16).foreground = Color.blue;
        scheme.getStyle((int)13).underline = true;
        scheme.getStyle((int)1).font = new Font("Georgia", 2, 12);
        scheme.getStyle((int)1).background = Color.cyan;
        this.textArea.revalidate();
    }

    private void changeStyleViaThemeXml() {
        try {
            Theme theme = Theme.load(this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/eclipse.xml"));
            theme.apply(this.textArea);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void setFont(RSyntaxTextArea textArea, Font font) {
        if (font != null) {
            SyntaxScheme ss = textArea.getSyntaxScheme();
            ss = (SyntaxScheme)ss.clone();
            for (int i = 0; i < ss.getStyleCount(); ++i) {
                if (ss.getStyle(i) == null) continue;
                ss.getStyle((int)i).font = font;
            }
            textArea.setSyntaxScheme(ss);
            textArea.setFont(font);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new SyntaxSchemeDemo().setVisible(true));
    }
}

