/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.ShorthandCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.mdkt.compiler.InMemoryJavaCompiler;

public class AutoCompleteDemo
extends JFrame {
    RSyntaxTextArea textArea;

    public AutoCompleteDemo() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.textArea = new RSyntaxTextArea(20, 60);
        this.textArea.setSyntaxEditingStyle("text/java");
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setFont(new FontUIResource("sansserif", 0, 20));
        contentPane.add(new RTextScrollPane(this.textArea));
        CompletionProvider provider = this.createCompletionProvider();
        AutoCompletion ac = new AutoCompletion(provider);
        ac.install(this.textArea);
        this.setContentPane(contentPane);
        this.setTitle("AutoComplete Demo");
        this.setDefaultCloseOperation(3);
        JPanel north = new JPanel();
        JButton loadB = new JButton("Load");
        loadB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputStream is = this.getClass().getResourceAsStream("/Hello.java");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                StringBuilder sb = new StringBuilder();
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                AutoCompleteDemo.this.textArea.setText(sb.toString());
            }
        });
        north.add(loadB);
        JButton saveB = new JButton("Save");
        saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(AutoCompleteDemo.this.textArea.getText());
            }
        });
        north.add(saveB);
        JButton execB = new JButton("Exec");
        execB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Class<?> helloClass = InMemoryJavaCompiler.newInstance().compile("Hello", AutoCompleteDemo.this.textArea.getText());
                    System.out.println(helloClass.getClass().getName());
                    System.out.println(helloClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).toString());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        north.add(execB);
        this.add((Component)north, "North");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private CompletionProvider createCompletionProvider() {
        DefaultCompletionProvider provider = new DefaultCompletionProvider();
        provider.addCompletion(new BasicCompletion((CompletionProvider)provider, "abstract"));
        provider.addCompletion(new BasicCompletion((CompletionProvider)provider, "assert"));
        provider.addCompletion(new BasicCompletion((CompletionProvider)provider, "break"));
        provider.addCompletion(new BasicCompletion((CompletionProvider)provider, "case"));
        provider.addCompletion(new BasicCompletion((CompletionProvider)provider, "transient"));
        provider.addCompletion(new BasicCompletion((CompletionProvider)provider, "try"));
        provider.addCompletion(new BasicCompletion((CompletionProvider)provider, "void"));
        provider.addCompletion(new BasicCompletion((CompletionProvider)provider, "volatile"));
        provider.addCompletion(new BasicCompletion((CompletionProvider)provider, "while"));
        provider.addCompletion(new ShorthandCompletion(provider, "sysout", "System.out.println(", "System.out.println("));
        provider.addCompletion(new ShorthandCompletion(provider, "syserr", "System.err.println(", "System.err.println("));
        return provider;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            try {
                String laf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            new AutoCompleteDemo().setVisible(true);
        });
    }
}

