/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import istlab.KisoJikken.App;
import istlab.KisoJikken.ConfigManager;
import istlab.KisoJikken.Launcher;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import javax.swing.JOptionPane;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.StashCreateCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitManager {
    Git git = null;
    Repository repository;
    ConfigManager configman;

    public GitManager(File root) throws IOException {
        this.repository = Git.open(new File(root.getParentFile().getAbsolutePath() + File.separator + ".git")).getRepository();
        this.configman = new ConfigManager(App.userhome);
    }

    public void checkClean(boolean skipByConfig) throws NoWorkTreeException, GitAPIException {
        this.git = new Git(this.repository);
        StatusCommand statusCommand = this.git.status();
        Status status = statusCommand.call();
        if (!status.isClean()) {
            if (this.configman.readAndCheckDate() && skipByConfig) {
                return;
            }
            System.out.println("Git\u306e\u30ed\u30fc\u30ab\u30eb\u30ea\u30dd\u30b8\u30c8\u30ea\u306b\u5909\u66f4\u70b9\u304c\u3042\u308a\u307e\u3059\u3002");
            Set<String> changedFiles = status.getModified();
            Set<String> untrackedFiles = status.getUntracked();
            System.out.println("\u5909\u66f4\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb:");
            for (String filePath : changedFiles) {
                System.out.println(filePath);
            }
            System.out.println("\u307e\u3060Git\u7ba1\u7406\u4e0b\u306b\u306a\u3044\u30d5\u30a1\u30a4\u30eb:");
            for (String filePath : untrackedFiles) {
                System.out.println(filePath);
            }
            JOptionPane.showMessageDialog(Launcher.theapp, "\u6559\u54e1\u63d0\u4f9b\u306eSampleSrc\u304c\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n\n[OK]\u3092\u62bc\u3059\u3068\u3001\u5909\u66f4\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\n( git status \u306e\u5b9f\u884c\u7d50\u679c ) \n\u3092\u5225\u30a6\u30a3\u30f3\u30c9\u30a6\u3067\u793a\u3057\u307e\u3059\u3002", "NWP\u30d5\u30a9\u30eb\u30c0\u306e\u72b6\u6cc1\u78ba\u8a8d", 2);
            Launcher.theapp.runCommand("git status -s", App.userhome + App.nwp, 600);
            int res = JOptionPane.showConfirmDialog(Launcher.theapp, "\u5909\u66f4\u5185\u5bb9\u306e\u8a73\u7d30\u3092\u307f\u308b\u306b\u306f cd ~/NWP ; git diff \u3092\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\n\u3053\u308c\u307e\u3067\u306e\u5909\u66f4\u5185\u5bb9\u3092\u6d88\u3057\u3066\uff0c\u521d\u671f\u72b6\u614b\u306b\u623b\u3057\u307e\u3059\u304b\uff1f\n\n\u300c\u306f\u3044\u300d\u3092\u62bc\u3059\u3068\uff0c\u5909\u66f4\u5185\u5bb9\u3092\u6d88\u3057\u3066\u521d\u671f\u72b6\u614b\u306b\u623b\u3057\u307e\u3059\u3002\n\u300c\u3044\u3044\u3048\u300d\u300c\u53d6\u6d88\u300d\u3092\u62bc\u3059\u3068\uff0c\u306a\u306b\u3082\u3057\u307e\u305b\u3093\u3002\n\n\u3042\u306a\u305f\u304c\u307e\u3060\u4f55\u3082\u4f5c\u696d\u3057\u3066\u304a\u3089\u305a\uff0c\u3053\u308c\u304b\u3089\u5b9f\u9a13\u3092\n\u59cb\u3081\u308b\u3068\u304d\u3060\u3051\u300c\u306f\u3044\u300d\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\u4f5c\u696d\u306e\u7d9a\u304d\u3092\u884c\u3046\u3068\u304d\u306f\u300c\u3044\u3044\u3048\u300d\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\uff08\u300c\u3044\u3044\u3048\u300d\u3067\u56de\u7b54\u3059\u308b\u3068\u30013\u65e5\u5f8c\u307e\u3067\u8d77\u52d5\u6642\u30c1\u30a7\u30c3\u30af\u3057\u307e\u305b\u3093\u3002\uff09", "\u6559\u54e1\u63d0\u4f9b\u306eSampleSrc\u304c\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059", 1);
            if (res == 0) {
                int res2 = JOptionPane.showConfirmDialog(Launcher.theapp, "\u3053\u308c\u307e\u3067\u306b\u7de8\u96c6\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u304c\u6d88\u3048\u307e\u3059\u3002\n\u672c\u5f53\u306b\u6d88\u3057\u3066\u3088\u3044\u3067\u3059\u304b\uff1f", "\u30d5\u30a1\u30a4\u30eb\u304c\u6d88\u3048\u307e\u3059", 1);
                if (res2 == 0) {
                    this.stash();
                    this.pull();
                    JOptionPane.showMessageDialog(Launcher.theapp, "\u521d\u671f\u72b6\u614b\u306b\u623b\u3057\u307e\u3057\u305f\u3002\n\n\u8aa4\u3063\u3066\u524a\u9664\u3057\u3066\u3057\u307e\u3063\u305f\u5834\u5408\u306f\u3001\n $ cd ~/NWP\n\u3092\u3057\u305f\u3042\u3068\u3067\n $ git stash list (\u9000\u907f\u60c5\u5831\u306e\u4e00\u89a7)\n $ git stash pop  (\u76f4\u524d\u306e\u9000\u907f\u60c5\u5831\u3092\u5fa9\u6d3b) \u307e\u305f\u306f\n $ git stash pop stash@{1} (\u6307\u5b9a\u3057\u305f\u9000\u907f\u60c5\u5831\u3092\u5fa9\u6d3b)\n\u3092\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            } else if (res == 1) {
                this.configman.write();
            }
        } else {
            if (!skipByConfig) {
                JOptionPane.showMessageDialog(Launcher.theapp, "\u5909\u66f4\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u306f\u3042\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n\nNo uncommitted changes in the local repository.");
            }
            System.out.println("No uncommitted changes in the local repository.");
        }
        if (this.git != null) {
            this.git.close();
        }
    }

    public void stash() throws GitAPIException {
        this.git = new Git(this.repository);
        StashCreateCommand stashCreateCommand = this.git.stashCreate();
        stashCreateCommand.setIncludeUntracked(true);
        SimpleDateFormat sdf = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        stashCreateCommand.setWorkingDirectoryMessage(sdf.format(new Date()) + " \u306b\u9000\u907f\u3057\u305f\u4f5c\u696d");
        RevCommit stashCommit = stashCreateCommand.call();
        if (stashCommit != null) {
            System.out.println("Stash created. Stash commit ID: " + stashCommit.getName());
        } else {
            System.out.println("No local changes to stash.");
        }
    }

    public void pull() throws GitAPIException {
        this.git = new Git(this.repository);
        PullCommand pullCommand = this.git.pull();
        pullCommand.call();
    }

    public void showNotice() {
        JOptionPane.showMessageDialog(Launcher.theapp, "(1) \u30c7\u30d0\u30a4\u30b9\u3092\u8a8d\u8b58\u3059\u308b\u3068\uff0c\u30bf\u30a4\u30c8\u30eb\u30d0\u30fc\u306b COM3 \u306e\u3088\u3046\u306b\u8868\u793a\u3057\u307e\u3059\u3002\n      \u8907\u6570\u307f\u3048\u308b\u3068\u304d\u306fWindows\u306e\u30c7\u30d0\u30a4\u30b9\u30de\u30cd\u30fc\u30b8\u30e3\uff1e\u30dd\u30fc\u30c8\u3067M5Stick\u306e\u30dd\u30fc\u30c8\u756a\u53f7\u3092\u8abf\u3079\u305f\u3046\u3048\u3067\uff0c\n      \u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306e Serial\u30e1\u30cb\u30e5\u30fc \u304b\u3089\uff0c\u66f8\u304d\u8fbc\u307f\u5148\u30dd\u30fc\u30c8\u3092\u9078\u3093\u3067\u304f\u3060\u3055\u3044\u3002\n\n(2) \u30c7\u30d0\u30a4\u30b9\u3092\u8a8d\u8b58\u3057\u306a\u3044\u3068\u304d\u306f\uff0c\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u518d\u8d77\u52d5\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002\n     \uff08App\u30e1\u30cb\u30e5\u30fc\uff1e\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u518d\u8d77\u52d5\u3059\u308b\uff09\n\n(3) \u30c7\u30d0\u30a4\u30b9\u3092\u8fd4\u5374\u3059\u308b\u3068\u304d\u306f\uff0cFactoryTest \u3092\u66f8\u304d\u8fbc\u3093\u3067\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002\n     \uff08File\u30e1\u30cb\u30e5\u30fc\uff1eFactoryTest\u3092\u66f8\u304d\u8fbc\u3080\uff09\n\n    \u30c7\u30d0\u30a4\u30b9\u306f\u5145\u96fb\u3057\u305f\u72b6\u614b\u3067\u8fd4\u5374\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "IoTP\u5b9f\u9a13\u306b\u304a\u3051\u308b\u5927\u4e8b\u306a\u6ce8\u610f\u70b9\u3067\u3059\u3002\u305f\u304f\u3055\u3093\u3042\u308a\u307e\u3059\u304c\u3057\u3063\u304b\u308a\u8aad\u3093\u3067\u304f\u3060\u3055\u3044\u3002", 2);
    }
}

