/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class ConfigManager {
    File userdir;

    public ConfigManager(String dir) {
        this.userdir = dir == null ? new File(System.getProperty("user.home")) : new File(dir);
    }

    public String getDate(int plusday) {
        LocalDate today = LocalDate.now();
        LocalDate futureDate = today.plusDays(plusday);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return futureDate.format(formatter);
    }

    public void write() {
        try {
            File file = new File(this.userdir.getAbsolutePath() + File.separator + ".nwp.conf");
            FileWriter fw = new FileWriter(file);
            fw.write(this.getDate(3));
            fw.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public boolean readAndCheckDate() {
        try {
            File file = new File(this.userdir.getAbsolutePath() + File.separator + ".nwp.conf");
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String today = this.getDate(0);
            String line = br.readLine();
            System.out.println(line + " " + today + " " + line.compareTo(today));
            if (br != null) {
                br.close();
            }
            return line.compareTo(today) > 0;
        }
        catch (IOException e) {
            return false;
        }
    }
}

