/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken;

import istlab.KisoJikken.MyFile;
import java.io.File;
import java.util.Arrays;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FileTreeModel
implements TreeModel {
    protected File root;
    boolean isExcludeClassFiles = false;

    public FileTreeModel(File root, boolean exCls) {
        this.root = root;
        this.isExcludeClassFiles = exCls;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((File)node).isFile();
    }

    private File[] getChildFiles(File parent) {
        if (this.isExcludeClassFiles) {
            return parent.listFiles(path -> !path.toString().endsWith(".class"));
        }
        return parent.listFiles();
    }

    @Override
    public int getChildCount(Object parent) {
        File[] children = this.getChildFiles((File)parent);
        if (children == null) {
            return 0;
        }
        return children.length;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object[] children = this.getChildFiles((File)parent);
        Arrays.sort(children);
        if (children == null || index >= children.length) {
            return null;
        }
        return new MyFile(((File)children[index]).getAbsolutePath());
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        Object[] children = this.getChildFiles((File)parent);
        Arrays.sort(children);
        if (children == null) {
            return -1;
        }
        String childname = ((File)child).getName();
        for (int i = 0; i < children.length; ++i) {
            if (!childname.equals(((File)children[i]).getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newvalue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }
}

