/*
 * Decompiled with CFR 0.152.
 */
package istlab.KisoJikken.Test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.mdkt.compiler.InMemoryJavaCompiler;

public class StyleTestDemo
extends JFrame {
    RSyntaxTextArea textArea;
    AbstractTokenMakerFactory atmf;

    public StyleTestDemo() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.textArea = new RSyntaxTextArea();
        String[] syntaxis = new String[]{"Simple2", "Simple", "MyCustom", "PlainText", "WordTest"};
        this.atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        for (String syn : syntaxis) {
            this.atmf.putMapping("text/" + syn, "istlab.KisoJikken.Test." + syn + "TokenMaker");
        }
        this.textArea.setSyntaxEditingStyle("text/" + syntaxis[0]);
        this.textArea.setHighlightCurrentLine(false);
        SyntaxScheme scheme = this.textArea.getSyntaxScheme();
        scheme.getStyle((int)1).background = Color.cyan;
        scheme.getStyle((int)3).background = Color.cyan.brighter();
        scheme.getStyle((int)4).background = Color.green;
        scheme.getStyle((int)5).background = Color.gray;
        scheme.getStyle((int)2).background = Color.yellow;
        this.textArea.setText("initial text /*.java \ncomment // com\n  https://www.istlab.info/ \n aaa /** asdf\n aaa \n */ \n aaa /* asdf\n aaa \n */  \n== \u30b3\u30f3\u30d1\u30a4\u30eb\u958b\u59cb ==\n> cd ~/NWP/src\n> javac -encoding UTF-8 j1/*.java\n==== end ===\n=== \u30b3\u30f3\u30d1\u30a4\u30eb\u7d42\u4e86 == (ALT+W\u3067\u9589\u3058\u308b)\n");
        this.textArea.revalidate();
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setFont(new FontUIResource("sansserif", 0, 20));
        contentPane.add(new RTextScrollPane(this.textArea, false));
        this.setContentPane(contentPane);
        this.setTitle("MySyntax Demo");
        this.setDefaultCloseOperation(3);
        JPanel north = new JPanel();
        JButton loadB = new JButton("Load");
        loadB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputStream is = this.getClass().getResourceAsStream("/Hello.java");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                StringBuilder sb = new StringBuilder();
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                StyleTestDemo.this.textArea.setText(sb.toString());
            }
        });
        north.add(loadB);
        JButton saveB = new JButton("Save");
        saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(StyleTestDemo.this.textArea.getText());
            }
        });
        north.add(saveB);
        JButton execB = new JButton("Exec");
        execB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Class<?> helloClass = InMemoryJavaCompiler.newInstance().compile("Hello", StyleTestDemo.this.textArea.getText());
                    System.out.println(helloClass.getClass().getName());
                    System.out.println(helloClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).toString());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        north.add(execB);
        for (String syn : syntaxis) {
            JButton javaB = new JButton(syn);
            javaB.addActionListener(e -> this.textArea.setSyntaxEditingStyle("text/" + syn));
            north.add(javaB);
        }
        this.add((Component)north, "North");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            try {
                String laf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            new StyleTestDemo().setVisible(true);
        });
    }
}

